%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function day_average=weekly_cycles(times,start_time,start_week_on_monday,loads)
%times are in days
    oneday=1;%24*3600;
    do_shift=1;
if (do_shift)
    times=times+shift_for_week(start_time,start_week_on_monday);%to fix the day of the week properly, 
else
    times=times+start_time(1);
end

%because the time start counting from 0 instead of from this time.
times=times(2:end);
loads=loads(2:end);
%times in days
%this is in particular for epoch
%                non_exceptionals=find(prices<8*min(prices));
average_by_samples=0;

time_diff=[0; diff(times)];
mean_occupancy=sum(time_diff.*loads)/(times(end)-times(1));%mean load
week_leftover=0;
day_of_week=ceil(mod((times-week_leftover),7));%mod((times-year2010)/3600,24);
day_average=zeros(7,1);

%plot weekly pattern

figure(700);
plot(mod((times-week_leftover),7),loads/max(loads),'o')
mysaveas(700,'weekly_pattern');



figure(701);
plot(mod((times-week_leftover),24),loads/max(loads),'o')
mysaveas(701,'daily_pattern');

total_time=day_average;
    
if (average_by_samples)
    day_average_rough=day_average;
    for day=1:7
        day_indices=find(day_of_week==day);
        %day_average(day)=day_indices;%mean(new_prices(day_indices))/mean_price;
        total_time(day)=sum(time_diff(day_indices));
        day_average(day)=sum(loads(day_indices).*time_diff(day_indices))/total_time(day);
        day_average_rough(day)=mean(loads(day_indices));
    end

    day_average=day_average/mean_occupancy
    rough_mean=mean(day_average_rough)
    day_average_rough=day_average_rough/rough_mean

else
    %do it methodically
    prev_pointer=1;
    day_sum=0;
    day_time=0;
    for pointer=1:length(times)
        current_time=times(prev_pointer);
        current_day_of_week=ceil(mod((current_time),7));
        if (current_day_of_week==0)
            current_day_of_week=7;
        end
        
       if (day_of_week(pointer)==current_day_of_week && (times(pointer)-current_time)<oneday)
            %they are within the same day
            tdiff=(times(pointer)-current_time);
            addload=tdiff*loads(prev_pointer);
            day_average(current_day_of_week)=day_average(current_day_of_week)+addload;
            total_time(current_day_of_week)=total_time(current_day_of_week)+tdiff;
            %figure(5);plot(current_day_of_week,total_time(current_day_of_week),'s'); hold on;
            day_sum(end)=day_sum(end)+addload;
            day_time(end)=day_time(end)+tdiff;
       %end
       else
       
        while ((~(day_of_week(pointer)==current_day_of_week) )|| (times(pointer)-current_time>=oneday))
            day_completion=1-mod(current_time,1);%go to the end of the day
            %if (day_completion<0.0001)
            %    day_completion=1;%skip to the next day
            %end
            next_time=current_time+day_completion;
            old_day_of_week=current_day_of_week;
            if (next_time>times(pointer))
                next_time=times(pointer);
                current_day_of_week=day_of_week(pointer);
            else
                current_day_of_week=ceil(mod((next_time),7));
            end
            if (current_day_of_week==0)
                current_day_of_week=7;
            end
            %am i attributing it to the correct day?
            tdiff=(next_time-current_time);
            addload=tdiff*loads(prev_pointer);
            day_average(current_day_of_week)=day_average(current_day_of_week)+addload;
            total_time(current_day_of_week)=total_time(current_day_of_week)+tdiff;
            if (current_day_of_week==old_day_of_week)
                dayjump=0;
            else
                dayjump=1;
                day_sum(end+1)=0;
                day_time(end+1)=0;
            end
            day_sum(end)=day_sum(end)+addload;
            day_time(end)=day_time(end)+tdiff;
            
           % figure(5);plot(current_day_of_week,total_time(current_day_of_week),'*');hold on;
            current_time=next_time;
            current_day_of_week=ceil(mod((current_time),7));
            if (current_day_of_week==0)
                current_day_of_week=7;
            end
            
        end
    end
time_diff_from_start=        sum(total_time)-(times(pointer)-times(1));
if(abs(time_diff_from_start)>0.01)
    disp('problem')
    time_diff_from_start
end
maxmin_total_time=max(total_time)-min(total_time);
if (maxmin_total_time>1)
    max(total_time)
    min(total_time)
    disp('problem incomplete week number')
end
prev_pointer=pointer;
if (mod(pointer,10000)==0)
figure(44);hold on;
plot(total_time/mean(total_time));
figure(55);
hold on;
plot(total_time);
end
    end

    day_average=day_average./total_time
    day_average=day_average/mean(day_average);
    day_sum=day_sum./day_time;
    weekmean=zeros(size(day_sum));
    last_index=length(day_sum);
    for i=1:7:length(day_sum)
        if (i+6<length(day_sum))
            weekmean(i)=mean(day_sum(i:i+6));
            normalized_day_sum(i:i+6)=day_sum(i:i+6)/weekmean(i);
            day_index(i:i+6)=mod(day_of_week(1)+[0:6],7);
            for j=i:i+6
                if (day_index(j)==0)
                    day_index(j)=7;
                end
            end
        else
            last_index=i-1;
        end
    end
end

for i=1:7
    day_means=normalized_day_sum(i:7:end);
    forbox(day_index(i),1:length(day_means))=day_means;
    day_mean_after_normalization(day_index(i),1:3)=quantile(day_means,[0.25 0.5 0.75]);
end
save daymean.txt day_mean_after_normalization -ASCII -DOUBLE
save daysum.txt normalized_day_sum -ASCII -DOUBLE
figure(334);
autocorr(normalized_day_sum);


figure(333);hold on;
plot(total_time/mean(total_time));hold on;plot(day_average,'r');title('total time and load');legend('time','average')


figure(66);hold on;
plot(day_index(1:last_index),normalized_day_sum(1:last_index),'o');

figure(77);
boxplot(forbox');
set(gca,'XTickLabel',{'Mon';'Tue';'Wed';'Thu';'Fri';'Sat';'Sun'})
mysaveas(77,'ibm_results/weekly_cycle-box');
end
