%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function [times,prices,first_step]=trim_window(times,prices,start_point,current_time,moving_window_number,moving_window_time)

first_step=find(times>=0,1,'first');

%trim data at current location for a sliding window
if (current_time>0)
    last_step=find(times<=current_time-start_point,1,'last');
else
    last_step=length(times);
end

if (moving_window_number>0)%trim early history
    if (last_step-first_step>moving_window_number)
        %allow at most moving_window_number information items
        first_step_by_window=last_step-moving_window_number;
    else
        first_step_by_window=first_step;
    end

    first_step_by_window_time=find(times<=times(last_step)-moving_window_time,1,'last');%at least window time in the history
    if (isempty(first_step_by_window_time))
        first_step_by_window_time=1;
    end
    first_step_by_window=min(first_step_by_window_time,first_step_by_window);%at least both (time and number)
    first_step=max(first_step_by_window,first_step);%trim beginning
end

%trim data before announcement - using Dec 14th, 08:00. Press release at Dec 14th.
prices=prices(first_step:last_step);
times=times(first_step:last_step);

end