%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function fignum=spots(os,cloud,fignum_in, just_histories,cutoff_point)
fast=0;
%os='linux';
%cloud='us-east-1';
color={'rs','gd','bs','c+','m*','r>','bx','mo'};
cloud_os=sprintf('%s.%s',cloud,os);
if (just_histories)
    fignum=fignum_in;
end


for i=1:8
    if (fast)
        close all;
    end
    instance=instance_name(i);
    %us-east-1.linux.m1.large.csv
    filename=sprintf('%s.%s',cloud_os,instance);
    on_demand=on_demand_price(os,cloud,i);
    if (i==1)
        first=1;
    else
        first=0;
    end
    if (just_histories)
        fignum_for_spot=fignum;
    else
        fignum_for_spot=fignum_in;
    end
    fignum=spot(filename,on_demand,color{i},first,cloud_os,fignum_for_spot,just_histories,cutoff_point);
end

if (just_histories==0)
    for fig=fignum_in+1:fignum
        figure (fig);
        legend(instance_name(1),instance_name(2),instance_name(3),instance_name(4),...
            instance_name(5),instance_name(6),instance_name(7),instance_name(8));
    end
    harig=9;
    if (fignum-fignum_in>=harig)
        figure(fignum_in+harig);
        legend('declared',...
            instance_name(1),instance_name(2),instance_name(3),instance_name(4),...
            instance_name(5),instance_name(6),instance_name(7),instance_name(8));
    end

    save_cloud_figs(fignum_in,cloud_os);
end
end

