%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function [fignum,long_term,critical_index]=spot(region,os,type_index,color_in,first,fignum,just_histories,...
    cutoff_point,moving_window_number,current_time,direc)

%why is this direc dummy? it is good for LPC, but not for othes, i think.
[times,prices,on_demand,cloud_os,filename,start_point,moving_window_time,direc_dummy,current_time_dummy,start_time]=...
    get_history(region,os,type_index,cutoff_point,moving_window_number,current_time);
only_cycle=0;
color=sprintf('%s-',color_in);

time_scale=3600*24;

if ((only_cycle==0) &&( ~(just_histories==2) && ~(just_histories==3)))
    fignum=fignum+1;figure(fignum);
    plot(times/time_scale,prices,color);hold on;
    title(sprintf('%s: history',cloud_os));
    if (time_scale==3600)
        sxlabel('time [h]');
    else
        sxlabel('time [days]');
    end
        sylabel('charged prices [$]');
    legend(filename);%in case doing just histories
    
    fignum=fignum+1;figure(fignum);hold on;
    title(sprintf('%s: history',cloud_os));
    x=shift_date(times,start_point,time_scale);
    if (time_scale==3600)
        sxlabel('time [h]');
    else
        sxlabel('time [days]');
    end
    plot(x,prices/on_demand,color);
    sylabel('charged prices as fraction of on demand price');
    if (time_scale==(3600*24))
        datetick('x','mmm') ;
        sxlabel('date');
    end
    legend(filename);%in case doing just histories
    
    fignum=fignum+1;figure(fignum);hold on;
    title(sprintf('%s: history',cloud_os));
    plot((times+global_first_time-year2010)/3600/24-365,prices,'g*');
    sxlabel('days since 1/1/2011');
    sylabel('spot price');
end
if (just_histories==1)
    if (only_cycle==0)
    mark=shift_date_point(went_online,start_point,time_scale);
    plot([mark mark], [min(prices) max(prices)]/on_demand,'k-');
    mark=shift_date_point(stopped_limiting_minimal_fee,start_point,time_scale);
    plot([mark mark], [min(prices) max(prices)]/on_demand,'k--');
    mark=shift_date_point(final_effects_of_minimal_fee_on_eu_west,start_point,time_scale);
    plot([mark mark], [min(prices) max(prices)]/on_demand,'k-.');
    legend(filename,'went online','second epoch ends', 'third epoch begins');%in case doing just histories

    end

    do_hour_of_day=1;
    if (do_hour_of_day)

        hour_of_the_day=ceil(mod(times/3600,24));%mod((times-year2010)/3600,24);

        mean_price=mean(prices);
        for hour=1:24
            hour_indices=find(hour_of_the_day==hour);
            hour_average(hour)=mean(prices(hour_indices))/mean_price;
        end

        %    fignum=fignum+1;figure(fignum);
        %    plot(hour_of_the_day,prices,'s');
        fignum=fignum+1;figure(fignum);
        plot(1:24,hour_average,color_in);
    end

    do_day_of_week=1;
    if (do_day_of_week)
        %this is in particular for epoch 
        non_exceptionals=find(prices<8*min(prices));
        
        start_week_on_monday=1;
        %start_time=0;
        day_average=weekly_cycles(times(non_exceptionals)/(3600*24),start_time,start_week_on_monday,prices(non_exceptionals))
        
        day_of_week=ceil(mod((times(non_exceptionals)-(25+1/12)*3600)/(3600*24),7));%mod((times-year2010)/3600,24);

        mean_price=mean(prices(non_exceptionals));
        new_prices=prices(non_exceptionals);
        for day=1:7
            day_indices=find(day_of_week==day);
            day_average(day)=mean(new_prices(day_indices))/mean_price;
        end

        %    fignum=fignum+1;figure(fignum);
        %    plot(hour_of_the_day,prices,'s');
%        fignum=fignum+1;
        fignum=1;
        figure(fignum);hold on;
        plot(1:7,day_average,color_in);
    end
    legend(filename);
    set(gca,'XTickLabel',{'Sun';'Mon';'Tue';'Wed';'Thu';'Fri';'Sat'})
    sylabel('mean daily price, normalized by mean price')

    return;
end

show_step_size=1;
if ( ( (~(just_histories==2)) && show_step_size) || (~(just_histories==3)))
    step_size=times(2:end)-times(1:end-1);
    proper_jumps_indices=find(step_size>1);
    if (~isempty(proper_jumps_indices))
        if (proper_jumps_indices(1)==1)
            proper_jumps_indices= proper_jumps_indices(2:end);
        end
    end
end


%fignum=spot_garch(prices(proper_jumps_indices),times(proper_jumps_indices),on_demand,fignum);

if ((~(just_histories==2)) && show_step_size)
%    fignum=bottom_price_history(times,prices,on_demand,color,cloud_os,fignum);
%    fignum=fignum-1;%return to the same figure
%    fignum=top_price_history(times,prices,on_demand,color,cloud_os,fignum);

    fignum=fignum+1;figure(fignum);hold on;

    %link between step length and the price level to which it is changed


    %plot(prices(proper_jumps_indices-1)/on_demand,step_size(proper_jumps_indices),'*b');
    %plot(prices(proper_jumps_indices)/on_demand,step_size(proper_jumps_indices),'+r');
    %legend('price before', 'price after');ylabel('step size');xlabel('price');

    plot(prices(proper_jumps_indices)/on_demand-prices(proper_jumps_indices-1)/on_demand,step_size(proper_jumps_indices),'*b');
    ylabel('step size');xlabel('price change');


    fignum=fignum+1;figure(fignum);hold on;
    plot(times(1:end-1)/3600,step_size/3600,'*b');
    sxlabel('time [h]');sylabel('step size [h]');


    fignum=fignum+1;figure(fignum);hold on;
    jumps=(prices(2:end)-prices(1:end-1))/on_demand;

    if (proper_jumps_indices(end)==length(jumps))
        proper_jumps_indices=proper_jumps_indices(1:end-1);
    end

    only_jumps=jumps(proper_jumps_indices+1);
    plot(only_jumps,step_size(proper_jumps_indices)/3600,color_in);
    sxlabel('price jump [fraction of on demand price]');sylabel('step size [h]');



    fignum=fignum+1;figure(fignum);hold on;
    x=(start_point-year2010+times(proper_jumps_indices+1))/24/3600;
    plot(x,step_size(proper_jumps_indices)/3600,color_in);
    sxlabel('price jump dates');sylabel('step size [h]');
    title(filename);


    %plot(x,loads,color);hold on; title('congestion');sxlabel('date');sylabel('Existance of congestion');
    %legend(filename);ylim([-0.1 1.3]);
    %datetick('x','mmm-yyyy') ;


    %    [r1,t1,p1]=spear(only_jumps,step_size(proper_jumps_indices)/3600)
    %    [r2,t2,p2]=spear(abs(only_jumps),step_size(proper_jumps_indices)/3600)
    
    fignum=fignum+1;figure(fignum);hold on;
    plot(only_jumps.*on_demand,step_size(proper_jumps_indices)/3600,color_in);
    sxlabel('price jump [$]');sylabel('step size [h]');
    
    %fignum=fignum+1;figure(fignum);hold on;
    %plot(only_jumps,step_size(proper_jumps_indices)/3600,'*b');
end
if (just_histories==4)
    return
end
if (~(just_histories==3))
    fignum=fignum+1;figure(fignum);
    [y,x]=ecdf(step_size(proper_jumps_indices)/3600);
    plot(x,y,'k-');
    hold on;
    title('cdf of step length');
    sxlabel('step length: time between price changes [h]');
    epsilon=0.01;%allow for a small mistake on the determination of time - this may account for a larger mistake in the height.
    probability_for_change_index=find(x<=1.5+epsilon,1,'last');
    probability_for_change=y(probability_for_change_index)
    probability_for_change_index2=find(x<=3+epsilon*2,1,'last');
    probability_for_change2_factor=...
        ((y(probability_for_change_index2)-y(probability_for_change_index))/(1-y(probability_for_change_index)))/y(probability_for_change_index)
    %(y(probability_for_change_index2)-y(probability_for_change_index))/(1-y(probability_for_change_index))
    [yguess,xguess]=step_length(probability_for_change,probability_for_change2_factor);
    sylabel('probability');
    plot(xguess,yguess,'r--');
    legend('Measured CDF','Simulated CDF');
    if (cutoff_point==9)
        myy=1-exp(-(x/1.5));plot(myx,myy,'b*');
        legend('Measured CDF','exponential CDF with halflife of 1.5 hours');
    end
end

[long_term,fignum,critical_index]=...
    prepare_long_term(times,prices,on_demand,filename,direc,fignum,color,...
    current_time,moving_window_number,moving_window_time);


all_unique_prices=long_term(:,1);
if (~(just_histories==3))
    [arcoeffs,white_noise_variance,fignum]=match_ar(prices,all_unique_prices,critical_index,fignum);

    show_load=0;
    if (show_load)
        fignum=plot_load(times,prices,all_unique_prices(critical_index),fignum,color,start_point,filename);
    end

    outfile=output_location(filename,direc,'_params',current_time,moving_window_number,moving_window_time);
    %    out=[price_range congested_fraction congested_fraction1 probability_for_change probability_for_change2_factor pbot' ptop']
    %the critical index tells us the number of levels, i suspect relevant to AR
    %parameters.
    out=[price_range congested_fraction congested_fraction1 probability_for_change probability_for_change2_factor critical_index arcoeffs white_noise_variance]
    save out.txt out -ASCII -DOUBLE;
    system(sprintf('mv out.txt %s',outfile));
    if (just_histories==2)
        return;
    end
end

availability_fraction=long_term(:,2:4);
average_paid=long_term(:,5:7);
crash_probability=long_term(:,8);

show_avail_fraction=1;
fignum=fignum+1;
fignum_avail_fraction=fignum;
if (show_avail_fraction)
    figure(fignum);
    plot(all_unique_prices/on_demand,availability_fraction(:,1),color);
    hold on;title (sprintf('%s: availability fraction',cloud_os));
    sxlabel('declared price [fraction of on demand price]');sylabel('availability fraction');
end

if (cutoff_point==1)
    [fignum,pbot,ptop]=analize_epochs(all_unique_prices,times,prices,on_demand,color,cloud_os,fignum,...
        went_online-global_first_time,stopped_limiting_minimal_fee-global_first_time,final_effects_of_minimal_fee_on_eu_west-global_first_time,...
        critical_index);
end

plot_avail=0;
if (plot_avail)
    figure(fignum_avail_fraction);
    plot(all_unique_prices(1:critical_index)/on_demand,availability_fraction(1:critical_index,2),color);
    plot(all_unique_prices(critical_index+1:end)/on_demand,availability_fraction(critical_index+1:end,3),color);
end

if ((just_histories==3) || (just_histories==2))
    return;
end


%fignum=plot_max_damage();
max_damage_from_crash=average_paid(1:plot_length,1)+(on_demand-average_paid(1:plot_length,1))./crash_probability;
%B&>&S(D)+\frac{F-S(D)}{Pc(D)}
fignum=fignum+1;figure(fignum);hold on;
plot(all_unique_prices(1:plot_length),max_damage_from_crash,color_in);
title(sprintf('%s: prefer on-demand if your damage from crash is higher than the line (combined range)',cloud_os));
xlabel('declared price [dollar per hour]');ylabel('max damage from crash [dollar per hour of one crash]');


fignum=fignum+1;figure(fignum);hold on;
plot(unique_prices/on_demand,durations,color);
title (sprintf('%s: number of seperate durations in which price was valid',cloud_os));
xlabel('fraction of on demand price');ylabel('number of continuous durations in measured interval');


fignum=fignum+1;
figure(fignum);
plot(all_unique_prices/on_demand,costsv(:,2)./costsv(:,1),color);hold on; xlabel('fraction of on demand price');ylabel('potential save by on-the-house last fraction (assuming full durations used)');
title('potential save due to on the house mechanism');

enough_data_indices=find(parmhat_logn(:,2) & (durations(:)>5));%sigma is larger than 0

show_fit=0;
if (show_fit)
    %dependency of distro on price
    fignum=fit_dependency_on_price(parmhat_exp,unique_prices,enough_data_indices,on_demand,color,'exp',cloud_os,fignum);
    fignum=fit_dependency_on_price(parmhat_logn(:,1),unique_prices,enough_data_indices,on_demand,color,'logn \mu',cloud_os,fignum);
    fignum=fit_dependency_on_price(parmhat_logn(:,2),unique_prices,enough_data_indices,on_demand,color,'logn \sigma',cloud_os,fignum);
    fignum=fit_dependency_on_price(parmhat_wbl(:,1),unique_prices,enough_data_indices,on_demand,color,'wbl A',cloud_os,fignum);
    fignum=fit_dependency_on_price(parmhat_wbl(:,2),unique_prices,enough_data_indices,on_demand,color,'wbl B',cloud_os,fignum);
end

fignum=fignum+1;
figure(fignum);
plot(unique_prices/on_demand,median_duration/3600,color);hold on;title (sprintf('%s: median duration',cloud_os));ylabel('median duration [hours]')
xlabel('charged price [fraction of on demand price]');

fignum=fignum+1;
figure(fignum);
positive_errorbar(unique_prices/on_demand,average_duration/3600,std_duration/3600,color);
hold on;title (sprintf('%s: average duration',cloud_os));ylabel('average duration [hours]')
xlabel('charged price [fraction of on demand price]');

unite_durations=1;
if (unite_durations)
    %plot(unique_prices/on_demand,average_duration_wait/3600,'k:v');
    positive_errorbar(unique_prices/on_demand,average_duration_wait/3600,std_duration_wait/3600,'k:v');
    hold on;title (sprintf('%s: average duration and wait',cloud_os))
    plot(unique_prices/on_demand,(average_duration+average_duration_wait)/3600,'r:v');hold on;title (sprintf('%s: average duration and wait',cloud_os));ylabel('average duration [hours]')
    legend('average duration','average wait duration', 'average cycle');
    

    fignum=fignum+1;
    figure(fignum);
    plot(unique_prices/on_demand,std_duration/3600,color);hold on;title (sprintf('%s: std duration',cloud_os));ylabel('std duration [hours]')
    xlabel('charged price [fraction of on demand price]');
    plot(unique_prices/on_demand,std_duration_wait/3600,'k:v');hold on;title (sprintf('%s: std duration and wait',cloud_os));
else
    fignum=fignum+1;
    figure(fignum);
    plot(unique_prices/on_demand,average_duration_wait/3600,color);hold on;title (sprintf('%s: average wait duration',cloud_os));ylabel('average wait duration [hours]')
    xlabel('charged price [fraction of on demand price]');
end


fignum=fignum+1;
figure(fignum);
plot(unique_prices/on_demand,average_duration./(average_duration+average_duration_wait),color);hold on;title (sprintf('%s: availability',cloud_os));ylabel('availability');
plot(all_unique_prices/on_demand,availability_fraction,'k:');
legend('average duration /cycle', 'availability fraction');
xlabel('charged price [fraction of on demand price]');

check_durations=0;
if (check_durations)
    pr=max(1,floor(no_congestion_index/4));ttl='ind quarter of congestion';
    fignum=present_wait_durations(fignum,price_duration_wait,durations_wait,pr,ttl);
    fignum=plot_durations_over_history(fignum,pr,price_duration_wait,durations_wait,price_duration,durations,price_start,prices,times,unique_prices,ttl);

    pr=max(1,floor(no_congestion_index/2));ttl='ind half congestion';
    fignum=present_wait_durations(fignum,price_duration_wait,durations_wait,pr,ttl);
    fignum=plot_durations_over_history(fignum,pr,price_duration_wait,durations_wait,price_duration,durations,price_start,prices,times,unique_prices,ttl);

    pr=max(1,floor(no_congestion_index/4*3));ttl='ind 3/4 congestion';
    fignum=present_wait_durations(fignum,price_duration_wait,durations_wait,pr,ttl);
    fignum=plot_durations_over_history(fignum,pr,price_duration_wait,durations_wait,price_duration,durations,price_start,prices,times,unique_prices,ttl);
    fignum=present_goodness_of_fit(pr,price_duration,...
        durations,unique_prices,parmhat_exp,parmhat_logn,parmhat_wbl,on_demand,fignum,ttl);



    if (no_congestion_index<length(unique_prices))
        pr=max(1,no_congestion_index);ttl='ind congestion';
        fignum=present_wait_durations(fignum,price_duration_wait,durations_wait,pr,ttl);
        fignum=plot_durations_over_history(fignum,pr,price_duration_wait,durations_wait,price_duration,durations,price_start,prices,times,unique_prices,ttl);
        pr=min (no_congestion_index+2, length(unique_prices));ttl='ind a bit (2?) above congestion';
        fignum=present_wait_durations(fignum,price_duration_wait,durations_wait,pr,ttl);
        fignum=plot_durations_over_history(fignum,pr,price_duration_wait,durations_wait,price_duration,durations,price_start,prices,times,unique_prices,ttl);
        fignum=present_goodness_of_fit(pr,price_duration,...
            durations,unique_prices,parmhat_exp,parmhat_logn,parmhat_wbl,on_demand,fignum,ttl);

        fignum=present_goodness_of_fit(ceil(mean([no_congestion_index length(unique_prices)])),...
            price_duration,durations,unique_prices,parmhat_exp,parmhat_logn,parmhat_wbl,on_demand,fignum,'ind above congestion');
    end


    fignum=plot_durations_over_history(fignum,length(unique_prices)-1,price_duration_wait,durations_wait,price_duration,durations,price_start,prices,times,unique_prices,'1 before end');
    fignum=plot_durations_over_history(fignum,length(unique_prices)-2,price_duration_wait,durations_wait,price_duration,durations,price_start,prices,times,unique_prices,'2 before end');

    fignum=present_goodness_of_fit(floor(no_congestion_index/4),price_duration,...
        durations,unique_prices,parmhat_exp,parmhat_logn,parmhat_wbl,on_demand,fignum,'ind quarter of congestion');
    fignum=present_goodness_of_fit(floor(no_congestion_index/2),price_duration,...
        durations,unique_prices,parmhat_exp,parmhat_logn,parmhat_wbl,on_demand,fignum,'ind half of congestion');
    fignum=present_goodness_of_fit(floor(3*no_congestion_index/4),price_duration,...
        durations,unique_prices,parmhat_exp,parmhat_logn,parmhat_wbl,on_demand,fignum,'ind 3/4 of congestion');
    fignum=present_goodness_of_fit(no_congestion_index,price_duration,durations,...
        unique_prices,parmhat_exp,parmhat_logn,parmhat_wbl,on_demand,fignum,'ind no congestion');
end

fignum=fignum+1;
figure(fignum);
hold on;
if (first)
    price_list=[min(all_unique_prices) max(all_unique_prices)]/on_demand;
    plot(price_list,price_list,'g-');%legend('paid','charged');
    price_list=[min(min(average_paid)) max(max(average_paid))]/on_demand;
    plot(price_list,price_list,'r-.');%legend('paid','charged');
end
plot(all_unique_prices/on_demand,average_paid(:,1)/on_demand,sprintf('%s-',color_in));
if (~isnan(average_paid(end,3)))
    plot(all_unique_prices/on_demand,average_paid(:,2)/on_demand,sprintf('%s-.',color_in));
    plot(all_unique_prices/on_demand,average_paid(:,3)/on_demand,sprintf('%s:',color_in));
    plot(all_unique_prices(no_congestion_index_all)/on_demand,all_unique_prices(no_congestion_index_all)/on_demand,'ks');
end
legend('unique prices range','average paid prices range','average paid prices','average paid prices  NOT congested', 'average paid prices when congested','top no congestion price');
title (sprintf('%s: average price paid when charging a certain price',cloud_os));
xlabel('fraction of on demand price declared');ylabel('average fraction of on demand price charged');

%Suppose I know the cdf using mu and sigma for a given price on a given
%resource : i know then the expectation value of the time between arrivals.
%I also know its distribution.
%Can I assume that if the price is currently lower than my limit,  then it
%will take half the mean duration on average to pass it? It could not be
%that it has nothing to do with how low the current price is!

%I also know what is my chance to find that the price will be above this
%line at any time.
%So, given that the current price is X, and my computation takes time Y_1 on resource 1, what price should i offer to finish
%the task in how much money and how long (bruto)?
%how much computation time will be spent when I do this (=energy), over the nominal non-preempted run?
%how much will I pay depends on the average price in durations under my
%limit (average_paid).
%when I consider several resources 1-N, on which the computation takes time 1-N, which resource should I use, and what price should I bid?

%I want to know the probability that the price will stay under X for
%duration Y, given that now it is under X?
%is it enough to measure only the amount of time spent in each state? Or is
%it interesting to know the frequency of the preiodic behavior?

%what is the expectation value of time until a price rises above value V2 for the first time,
%given the current value is V1? does V1 really matter?

%for this I need the CDF of price
end



function [fignum,drop_time]=...
    time_to_reach(all_unique_prices,times,prices,lucky,no_congestion_index_all,congestion_range,fignum)

drop_time=zeros(length(all_unique_prices),length(all_unique_prices));

drop_time(:,:)=NaN;%prevent from being displayed in graph
%maybe 1:no_congestion_index_all ?
for pr=1:length(all_unique_prices)%go over all unique prices

    price=all_unique_prices(pr);
    hi_price_ends=find(prices(1:end-1)==price & (~(prices(2:end)==price)));

    for pr_low=1:pr-1%all lower prices
        price_low=all_unique_prices(pr_low);
        accumulator=0;
        acc_number=0;
        for i=1:length(hi_price_ends)
            if (lucky)
                finally=find(prices(hi_price_ends(i):end)<=price_low,1,'first');
            else
                finally=find(prices(hi_price_ends(i):end)<price_low,1,'first');
            end
            if (isempty(finally))
                break;
            end
            acc_number=acc_number+1;
            accumulator=accumulator+times(finally+hi_price_ends(i)-1)-times(hi_price_ends(i));
        end
        drop_time(pr_low,pr)=accumulator/acc_number;
    end
end
fignum=fignum+1;
figure(fignum);
hold on;
drop_time
title('avertage time to transfer from price to price');
ylabel('transfer down to');
xlabel('transfer from');%verified
surf(drop_time);colorbar;
%plot(all_unique_prices,drop_time,'k-');

fignum=fignum+1;
figure(fignum);
hold on;
for pr_low=1:length(all_unique_prices)%go over all unique prices
    plot(all_unique_prices(pr_low+1:end),drop_time(pr_low,pr_low+1:end)/3600);
end
end


function [fignum,jump]=probability_to_reach(all_unique_prices,times,prices,fignum)

jump=zeros(length(all_unique_prices),length(all_unique_prices));

%count jumps betwen each pair
price1=prices(1);
price1_index=find(all_unique_prices==price1,1,'first');
for step=2:length(prices)
    price2=prices(step);
    price2_index=find(all_unique_prices==price2,1,'first');
    if (~(price1_index==price2_index))
        jump(price1_index,price2_index)=jump(price1_index,price2_index)+1;%from price1 to price2
    end
    price1_index=price2_index;%save for next round

end


color={'rs','gd','bs','c+','m*','r>','bx','mo','r^','g<','bv','ch','mp'};
fignum=fignum+1;
figure(fignum);hold on;
buckets=1:0.1:2;
buckets=unique([1./buckets buckets 0]);
collective=zeros(size(buckets));
for i=1:length(all_unique_prices)
    jumps=length(find(jump(i,:)>0));
    if (jumps>1)
%normalize per each starting point
        jump(i,:)=jump(i,:)/sum(jump(i,:));

        scaled_price=all_unique_prices/all_unique_prices(i);
        inds=find(jump(i,:)>0);
        for ind=1:length(inds)
            place=inds(ind);
            bucket=find(buckets<scaled_price(place),1,'last');
            collective(bucket)=collective(bucket)+jump(i,place);
        end
        this_color=char(color(1+mod(i,length(color))));
        plot(scaled_price(inds),jump(i,inds),strcat(this_color,'-'));
        plot(1./scaled_price(inds),jump(i,inds),strcat(this_color,':'));
    end
end

title('chance to transfer from price to price of relative size');
xlabel('destination price');
ylabel('probability');

collective=collective/sum(collective);
fignum=fignum+1;
figure(fignum);hold on;
plot(buckets,collective,'k-');
plot(1./buckets,collective,'k:');



len_price=length(all_unique_prices);
diff1=all_unique_prices(2)-all_unique_prices(1);%the notch - quantization level
total_price_diffs=-len_price*diff1:diff1:len_price*diff1;
total_probabilities_list=zeros(size(total_price_diffs));


%Create difference table to price pairs
price_diffs=zeros(length(all_unique_prices));
for p1=1:len_price
    for p2=1:len_price
        price_diffs(p1,p2)=all_unique_prices(p1)-all_unique_prices(p2);
        notch=len_price+1+price_diffs(p1,p2)/diff1;%check!
        if (total_price_diffs(notch)==price_diffs(p1,p2))
        total_probabilities_list(notch)=total_probabilities_list(notch)+jump(p1,p2);
        else
            disp('problem')
        end
    end
end

 total_probabilities_list= total_probabilities_list/len_price;
 save total_probabilities_list -ASCII -DOUBLE

 
 
 
for p1=1:len_price
    total_probabilities_list2(p1)=0.5*(total_probabilities_list(p1)+total_probabilities_list(end-p1+1));
end
figure(55);plot(total_price_diffs(1:length(total_probabilities_list2)),total_probabilities_list2);


%take a log, and make sure the starting point is 0 - log(1) is 0.
log_all_unique_prices=log(all_unique_prices/prices(1));
log_prices=log(prices/prices(1));
jumps_list=[];
num_jumps=zeros(size(all_unique_prices));
%count jumps betwen each pair
price1=log_prices(1);
price1_index=find(log_all_unique_prices==price1,1,'first');
for step=2:length(prices)
    price2=log_prices(step);
    price2_index=find(log_all_unique_prices==price2,1,'first');
    if (~(price1_index==price2_index))
        num_jumps(price1_index)=num_jumps(price1_index)+1;
        jumps_list(price1_index,num_jumps(price1_index))=price2-price1;%from price1 to price2
    end
    price1_index=price2_index;%save for next round
    price1=price2;%save for next round

end


show_mu_match=0;
if(show_mu_match)
fignum=fignum+1;
figure(fignum);hold on;

inds_enough_jumps=find(num_jumps>2);
for_probplot=jumps_list(inds_enough_jumps,:);
probplot(for_probplot);

fignum=fignum+1;
figure(fignum);hold on;
parmhat=zeros(length(all_unique_prices),2);
for i=1:length(all_unique_prices)
    if (num_jumps(i)>2)
        
        probplot(jumps_list(i,1:num_jumps(i)));hold on;
        [parmhat(i,1) parmhat(i,2)]=normfit(jumps_list(i,1:num_jumps(i)));
    end
end
title('prob plots - normal distribution - jump sizes in log scale');
xlabel('ujump size (between logs)');
ylabel('probability');

fignum=fignum+1;
figure(fignum);hold on;
plot(log_all_unique_prices(inds_enough_jumps),parmhat(inds_enough_jumps,1));
title('\mu');

fignum=fignum+1;
figure(fignum);hold on;
plot(log_all_unique_prices(inds_enough_jumps),parmhat(inds_enough_jumps,2));
title('\sigma');


%work by constant intervals
delta_t=3600*1.5;
time_period=floor((times(end)-times(1))/delta_t);%how many hours
time_sample=1:time_period;
price_sample=zeros(size(time_sample));
time_sample_place=zeros(size(time_sample));

for i=1:length(time_sample)    
    time_sample_place(i)=find(times>=time_sample(i)*delta_t,1,'first');
    price_sample(i)=prices(time_sample_place(i));
end
%now price_sample and time_sample are with intervals of 1 hour exactly.
log_price_sample=log(price_sample/price_sample(1));
end
%diff_log_price_sample=log_price_sample(2:end)-log_price_sample(1:end-1);%the jumps of logs
%fignum=fignum+1;figure(fignum);
%probplot(diff_log_price_sample);hold on;title(sprintf('%g hour diffs',delta_t/3600));xlabel('log price difference(price normalized by initial price)')

%fignum=fignum+1;figure(fignum);
%probplot(diff_log_price_sample(abs(diff_log_price_sample)>0));hold on;title(sprintf('%g hour diffs, without standing in place',delta_t/3600));xlabel('log price difference(price normalized by initial price)')

show_autocorrelation=2;
if (show_autocorrelation)
    fignum=fignum+1;
    surf(jump);
if (show_autocorrelation==2)
    fignum=fignum+1;figure(fignum);
    
end
if (show_autocorrelation==1)
for skip=[1 5 10]

    diff_log_price_sample=log_price_sample(1+skip:skip:end)-log_price_sample(1:skip:end-skip);%the jumps of logs
    fignum=fignum+1;figure(fignum);
    probplot(diff_log_price_sample);hold on;title(sprintf('%g hour diffs',skip*delta_t/3600));xlabel('log price difference(price normalized by initial price)')

    
    fignum=fignum+1;figure(fignum);
    inds_not_in_place=find(abs(diff_log_price_sample)>0);
    probplot(diff_log_price_sample(inds_not_in_place));hold on;title(sprintf('%g hour diffs, without standing in place',skip*delta_t/3600));
    xlabel('log price difference(price normalized by initial price)')


    fignum=fignum+1;
    figure(fignum);
    plot(diff_log_price_sample(1:end-1),diff_log_price_sample(2:end),'*');title(sprintf('%g hour diffs, correspondence scatter',skip*delta_t/3600));
    
    fignum=fignum+1;
    figure(fignum);
    plot(diff_log_price_sample(inds_not_in_place(1:end-1)),diff_log_price_sample(inds_not_in_place(2:end)),'*');title(sprintf('%g hour diffs, correspondence scatter, without standing in place',skip*delta_t/3600));
end
end
end
end



function positive_errorbar(x,y,stdy,color)
up=stdy;
down=min(y,stdy);
errorbar(x,y,down,up,color);
end

function fignum=plot_durations_over_history(fignum,pr,price_duration_wait,durations_wait,price_duration,durations,price_start,prices,times,unique_prices,ttl)
fignum=fignum+1;
figure(fignum);hold on;
plot(times,prices,'c-');
start=price_start(pr);

price=unique_prices(pr);
for d=1:min(durations_wait(pr),durations(pr))
    
    epoint=start+price_duration(pr,d);
    plot([start epoint],[price price],'b:');
    start=epoint;
    
    epoint=start+price_duration_wait(pr,d);
    plot([start epoint],[price price],'r-');
    start=epoint;
end

if (durations(pr)>durations_wait(pr))
    for d=durations(pr)+1:durations_wait(pr)
        epoint=start+price_duration(pr,d);
        plot([start epoint],[price price],'b:');
        start=epoint;
    end
end
title(sprintf('%s price=%g',ttl,price));
end


function fignum=present_wait_durations(fignum,price_duration_wait,durations_wait,pr,ttl)
fignum=fignum+1;
figure(fignum);hold on;
[y,x]=ecdf(price_duration_wait(pr,1:durations_wait(pr)));
x3600=x/3600;%hours
plot(x3600,y,'b');
title(sprintf('wait durations for %s',ttl));
end

function fignum=fit_dependency_on_price(parmhat,unique_prices,enough_data_indices,on_demand,color,ttl,cloud_os,fignum)
fignum=fignum+1;
figure(fignum);
plot(unique_prices(enough_data_indices)/on_demand,parmhat(enough_data_indices),color);
hold on;title (sprintf('%s: %s of cdf for duration length for a declared price',cloud_os,ttl));
xlabel('fraction of on demand price');ylabel('mle parameter value');
end

function [fignum,pbot,ptop]=analize_epochs(all_unique_prices,times,prices,on_demand,color,cloud_os,fignum,...
    went_online,stopped_limiting_minimal_fee,final_effects_of_minimal_fee_on_eu_west,critical_index)
mintime=[-Inf,went_online,final_effects_of_minimal_fee_on_eu_west];
maxtime=[went_online, stopped_limiting_minimal_fee, Inf];
colorin={'rs','gd','bs','c+','m*','r>','bx','mo','r^','g<','bv','ch','mp'};
color_index=1;
for i=1:3
    fignum=fignum+1;figure(fignum);hold on;
    [fignum,bottom_turns,num_bot]=bottom_price_history(times,prices,on_demand,color,cloud_os,-fignum,1,all_unique_prices,mintime(i),maxtime(i));
    [fignum,top_turns,num_top]=bottom_price_history(times,prices,on_demand,color,cloud_os,-fignum,0,all_unique_prices,mintime(i),maxtime(i));
    if (num_top+num_bot>0)
        %    this_color=char(colorin(i));
        for j=1:length(all_unique_prices)
            if (bottom_turns(j)==0)
                bottom_turns(j)=NaN;
            end
            if (top_turns(j)==0)
                top_turns(j)=NaN;
            end
        end
        plot(all_unique_prices/on_demand,bottom_turns,char(colorin(color_index)));color_index=color_index+1;%strcat(this_color,'-'));
        plot(all_unique_prices/on_demand,top_turns,char(colorin(color_index)));color_index=color_index+1;%strcat(this_color,'--'));
        legend(sprintf('Bottom turnpoints in epoch %d',i),sprintf('Top turnpoints in epoch %d',i));
        sxlabel('turnpoint price (fraction of on-demand price)');sylabel('Probability of a turnpoint');
        xl=ylim;
        if (~isnan(xl(2)))
            ylim([0 xl(2)]);
        end
        xl=xlim;
        if (~isnan(xl(2)))
            xlim([0.4 xl(2)]);
        end
    end
end

x=all_unique_prices(1:critical_index)/on_demand;



pbot=polyfit_with_nans(x',bottom_turns(1:critical_index));
ptop=polyfit_with_nans(x',top_turns(1:critical_index));
ftop=polyval_with_nans(ptop,x);
fbot=polyval_with_nans(pbot,x);
plot(x,ftop,'k-');
plot(x,fbot,'k-');
%legend('bottom turnpoints epoch 1','top turnpoints epoch 1',...
%    'bottom turnpoints epoch 2','top turnpoints epoch 2',...
%    'bottom turnpoints epoch 3','top turnpoints epoch 3');



end

function yfit=polyval_with_nans(p,x)
yfit = p(1) + p(2)*x + p(3)*x.*x;
end

function b=polyfit_with_nans(x1,y)
b=regress(y',[ones(size(x1)); x1; x1.*x1]');
end

function [fignum,num_bottompoints,num_points]=bottom_price_history(times,prices,on_demand,color,cloud_os,fignum,bottom,all_unique_prices,mintime,maxtime)
bottom_prices=[];
bottom_times=[];
for step=3:length(times)-1
    if (times(step-2)>=mintime && times(step)<=maxtime)
        if (prices(step)==prices(step-1))%turnpoint
            if ((bottom==1 && prices(step-2)>prices(step) && prices(step)<prices(step+1))...%a bottom
                    || (bottom==0 && prices(step-2)<prices(step) && prices(step)>prices(step+1)))%a top
                bottom_prices(end+1)=prices(step);
                bottom_times(end+1)=times(step);
            end
        end
    end

end
num_points=length(bottom_prices);
if (fignum>0)
    fignum=fignum+1;
    figure(fignum);hold on;
    plot(bottom_times/3600,bottom_prices/on_demand,color);hold on;title(sprintf('%s: top bottom prices',cloud_os));sylabel('charged price [fraction of on demand price]');
    sxlabel('time [h]');
else
    fignum=-fignum;

    %bottom price statistics
    num_bottompoints=zeros(1,length(all_unique_prices));
    for i=1:length(bottom_prices)
        ind=find(all_unique_prices==bottom_prices(i),1,'first');
        num_bottompoints(ind)=num_bottompoints(ind)+1;
    end
    num_bottompoints=num_bottompoints./num_points;
end
end




function fignum=probplot_durations(fignum,pr,unique_prices,durations,price_duration,on_demand,ttl,dist)
figure(fignum);hold on;probplot(dist,price_duration(pr,1:durations(pr))/3600);
title(sprintf('%s: price fraction %g, %s',ttl,unique_prices(pr)/on_demand,dist)); xlabel('price duration [h]');
fignum=fignum+1;
end

function fignum=present_goodness_of_fit(pr,price_duration,durations,unique_prices,parmhat_exp,parmhat_logn,parmhat_wbl,on_demand,fignum,ttl)
fignum=fignum+1;
if (pr==0 || pr>length(durations))
    return;
end
do_probplots=0;

%plot cdf, logn cdf and exponential cdf.
figure(fignum);hold on;
[y,x]=ecdf(price_duration(pr,1:durations(pr)));
x3600=x/3600;%hours
plot(x3600,y,'b');
hold on;
ylogn=cdf('logn',x,parmhat_logn(pr,1),parmhat_logn(pr,2));
plot(x3600,ylogn,'k');
yexp=cdf('exp',x,parmhat_exp(pr));
plot(x3600,yexp,'r');

ywbl=cdf('wbl',x,parmhat_wbl(pr,1),parmhat_wbl(pr,2));
plot(x3600,ywbl,'m');

legend('effective','logn','exp','wbl');xlabel('price duration [h]');ylabel('fraction of durations (CDF)');
title(sprintf('%s:price fraction %g',ttl,unique_prices(pr)/on_demand));
fignum=fignum+1;
if (do_probplots)
fignum=probplot_durations(fignum,pr,unique_prices,durations,price_duration,on_demand,ttl,'logn');
fignum=probplot_durations(fignum,pr,unique_prices,durations,price_duration,on_demand,ttl,'wbl');
fignum=probplot_durations(fignum,pr,unique_prices,durations,price_duration,on_demand,ttl,'exp');
end

end


function fignum=spot_garch(prices,times,on_demand,fignum)
%chop before the peak
last_index=floor(length(prices)/4);
prices=prices(1:last_index);
times=times(1:last_index);

ts=timeseries(prices,times);
 [RetSeries , RetIntervals] = price2ret(prices , times );
 fignum=fignum+1; figure(fignum);hold on;
 plot(cumsum(RetIntervals/3600),RetSeries);title('returns from prices (for the garch)');xlabel('time [h]');
 fignum=fignum+1; figure(fignum);hold on;
 autocorr(RetSeries ,20,10,0);
 [ACF,Lags,Bounds] =autocorr(RetSeries ,20,10,0);
 fignum=fignum+1; figure(fignum);hold on; 
 parcorr(RetSeries ,20,10,0);
 fignum=fignum+1; figure(fignum);hold on;
 autocorr(RetSeries.^2 ,20,10,0);
[H,pValue,Stat,CriticalValue] = lbqtest(RetSeries-mean(RetSeries),[10 15 20 50]',0.05)
[H,pValue,Stat,CriticalValue] = archtest(RetSeries-mean(RetSeries),[10 15 20 50]',0.05)
[Coeff,Errors,LLF,Innovations,Sigmas,Summary] = garchfit(RetSeries)
garchdisp(Coeff,Errors)
fignum=fignum+1; figure(fignum);hold on;
garchplot(Innovations,Sigmas,RetSeries);
p=0;
q=0;
r=2;
m=2;
%p=20;

%for i=1:7
%    for j=1:1
        [spec21,coeff21,errors21,LLF21,eFit,sFit,H]=check_fit(RetSeries,p,q,r,m);
        garchdisp(coeff21,errors21)
%    end
%end


%specG2 = garchset(coeff21,'GARCH',[0.8 0],'FixGARCH',[0 1]);
%[coeffG2,errorsG2,LLFG2] = garchfit(specG2,RetSeries-mean(RetSeries));
%garchdisp(coeffG2,errorsG2)
%[H,pValue,Stat,CriticalValue] = lratiotest(LLF21,LLFG2,1,0.05)

from_end=50;
start_time=times(end-from_end);
nPaths=10;
randn('state',0);
rand('twister',0); 
horizon=20;

[eSim,sSim,ySim] = garchsim(coeff21,horizon,nPaths, ...
   [],[],[], eFit(end-from_end-H:end-from_end),sFit(end-from_end-H:end-from_end),RetSeries(end-from_end-H:end-from_end));
%innovations, sigmas, series

fignum=fignum+1;figure(fignum);
plot(times(2:end),RetSeries,'r');hold on;
plot(times(end-from_end+1:end-from_end+horizon),ySim,'k');
title('returns');legend('reality','MC predictions');

%restored_prices=ret2price(RetSeries,prices(1),RetIntervals,times(1));
new_prices=ret2price(ySim,prices(end-from_end),RetIntervals(end-from_end),times(end-from_end+1));
fignum=fignum+1;figure(fignum);hold on;
plot(times,prices,'r');hold on;
%plot(times,restored_prices,'g');
plot(times(end-from_end:end-from_end+horizon),new_prices,'k');
title('prices');legend('reality','MC predictions');
xlabel('time[s]');


%working on prices instead of returns
stillgo=1;
while (stillgo)
p=0;
q=0;
r=2;
m=0;
[spec21,coeff21,errors21,LLF21,eFit,sFit,H]=check_fit(prices,p,q,r,m);
garchdisp(coeff21,errors21)

[eSim,sSim,ySim] = garchsim(coeff21,horizon,nPaths, ...
   [],[],[], eFit(end-from_end-H:end-from_end),sFit(end-from_end-H:end-from_end),prices(end-from_end-H:end-from_end));
fignum=fignum+1;figure(fignum);hold on;
plot(times,prices,'r');
plot(times(end-from_end+1:end-from_end+horizon),ySim,'k');
title('prices');legend('reality','MC predictions by prices');
stillgo=0;
end
end


function [spec21,coeff21,errors21,LLF21,eFit,sFit,H]=check_fit(RetSeries,p,q,r,m)
H=max(r,m);
maxpq=max(p,q);%needed length of history
H=max(H,maxpq);

spec21 = garchset('P',p,'Q',q,'Display','off','VarianceModel','GARCH','R',r,'M',m);
[coeff21,errors21,LLF21,eFit,sFit] = garchfit(spec21,RetSeries);
garchdisp(coeff21,errors21)
end

function x=shift_date(times,start_point,time_scale)
if (time_scale==3600*24)
    x=(start_point-year2010()+times)/time_scale;
else
    x=times/time_scale;
end
end

function x=shift_date_point(times,start_point,time_scale)
if (time_scale==3600*24)
    x=(times-year2010())/time_scale;
else
    x=(times-start_point)/time_scale;
end
end

function fignum=plot_load(times,prices,critical_price,fignum,color,start_point,filename)
loads=prices;
loads(loads>critical_price)=1;
loads(loads<=critical_price)=0;
fignum=fignum+1;
figure(fignum);
x=(start_point-year2010()+times)/24/3600;
plot(x,loads,color);hold on; title('congestion');sxlabel('date');sylabel('Existance of congestion');
legend(filename);ylim([-0.1 1.3]);
basey = 0;%min(0,min(y)); 
ShadingColor='b';
h = fill([x' x(end) x(1)], [loads' basey basey], ShadingColor); 
% finally, also is there a way to make this shading color somewhat  transparent? 
set(h, 'EdgeColor','none', 'FaceAlpha', 0.54321); 
datetick('x','mmm') ;
end

function [arcoeffs,evar,fignum]=match_ar(prices,all_unique_prices,critical_index,fignum)
arinput=prices(1:2:end);
critical_index
size(all_unique_prices)
mean_price=mean(all_unique_prices(1:critical_index));%there can be other methods
price_diffs=arinput(2:end)-arinput(1:end-1);
%price_diffs=price_diffs(find(~(price_diffs==0)));
[arcoeffs,evar]=arcov(price_diffs,1);
if (fignum>0)
    fignum=my_ar1(mean_price,0,arcoeffs,sqrt(evar),all_unique_prices(1),all_unique_prices(critical_index),fignum,price_diffs);%todo
    hold on;plot(arinput,'r');legend('my chopped (by retry) AR process','original prices');
else
    fignum=-fignum;
end
end

