%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function [spot_price,sold]=second_price(bids_in,Nmax,min_price)
%second price with maximal capacity, selling an optimal amount (sold), with
%a minimal price.

acceptable_bids_indices=find(bids_in>=min_price);%get rid of currently illegal ones
if (isempty(acceptable_bids_indices))
    spot_price=min_price;
    sold=0;
    return;
end
bids=sort(bids_in(acceptable_bids_indices),1,'descend');%sort the legal ones
at_most=min(length(bids),Nmax);%limit, if needed
index=[1:1:at_most]';
bids(end+1)=min_price;%extra "fake" one - lion in Cairo, also allow a shift
revenue_if_sold=bids(2:(min(length(bids),at_most+1))).*index(1:end);%second price for all amount od sold goods
[max_rev,sold]=max(revenue_if_sold);
spot_price=bids(sold+1);
return;
end