%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function [occupied_time,occupied_time_upto_median,max_nodes_is_at_least,fignum,total_time]=plot_occupancy(tin,nodes,granularity,fignum,scale,start_time)

    %each process gets - field 5
   %      cpu_time    sent(submit)_time makespan status
%    tin1=[feittr(:,4) feittr(:,2) feittr(:,4)+feittr(:,3) feittr(:,11)];
tin1=tin;%(:,2;
ndata=size(tin1,1);

plot_pattern_growth=1;
if (plot_pattern_growth)
    %by days
    submit_time=tin1(:,2)/3600/24;
    run_time=tin1(:,1)/3600/24;
    end_time=submit_time+run_time;
    submit_month=floor(submit_time/30.5);
    submit_time_in_week=mod(submit_time,7);
    end_time_in_week=mod(end_time,7);
    max_month=max(submit_month);
    for i=0:max_month
        this_month=find(submit_month==i);
        if (~isempty(this_month))
            figure(2000+i);hold on;title(sprintf('month %d',i));
            plot(run_time(this_month),submit_time_in_week(this_month),'ro');
            plot(run_time(this_month),end_time_in_week(this_month),'b+');
        end
    end
end

history=zeros(ndata*3,4);
hcounter=1;
for i=1:ndata
    wait=tin1(i,3)-tin1(i,1);
    cpus=tin1(i,5);
    submit_time=tin1(i,2);
    if (wait>0)
        history(hcounter,:)=[submit_time 0 cpus 0 ];hcounter=hcounter+1;%add to waiting
    end
    if (tin1(i,1)>0)%there was some cpu time
        %time,                 change to running,    change to waiting, cancellation
        if (wait>0)
            history(hcounter,:)=[submit_time+wait  cpus  -cpus 0 ];hcounter=hcounter+1;%take from waiting, add to running
        else

            history(hcounter,:)=[submit_time cpus 0 0 ];hcounter=hcounter+1; %add directly to running
        end
        history(hcounter,:)=[submit_time+tin1(i,3)           -cpus   0           0 ];hcounter=hcounter+1;%take from running - done
    else%cancelled, or as good as?
        if (wait>0)
        when=submit_time+tin1(i,3)-tin1(i,1);
        history(hcounter,:)=[when                           0     -cpus cpus];hcounter=hcounter+1;%take from waiting - lost tasks?
        end
    end
end
history=history(1:hcounter,:);%limit size to actually used places
history=sortrows(history,[1 2]);%sort by time , WE MUST SORT BY ACTIVITY TOO!!!SORTROWS(X,[2 -3])
%time running waiting cancelled
history_status=[history(:,1) cumsum(history(:,2:3)) history(:,4)];

fignum=fignum+1;figure(fignum);
time_plot(history_status(:,1)/scale,history_status(:,2),'r');hold on;%running
%plot(history_status(:,1),history_status(:,2)+history_status(:,3),'g*');%running+waiting
time_plot(history_status(:,1)/scale,history_status(:,3),'g');%waiting
max_nodes_is_at_least=max(history_status(:,2))
nodes_for_plot=max(nodes,max_nodes_is_at_least);
plot([history_status(1,1) history_status(end,1)]/scale,[nodes_for_plot nodes_for_plot],'k-.');
plot([history_status(1,1) history_status(end,1)]/scale,[nodes nodes],'k--');
total_time=history_status(end,1)-history_status(1,1);
%cancellation=find(history(:,4)>0);
%torun=find(history(:,2)>0);
%plot(history_status(cancellation,1),history_status(cancellation,2)+history_status(cancellation,3),'b:x');
%plot(history_status(torun,1),history_status(torun,2)+history_status(torun,3),'m:x');
legend('running',...%'waiting+running',
'waiting','max nodes','input nnodes',...%'cancellation events',
'started running events');



start_week_on_monday=1;
look_for_day_average=0;
if(look_for_day_average)
    %what I needed to show that there is a weekly cycle in clouds
    day_average=weekly_cycles(history_status(:,1)/(24*3600),start_time,start_week_on_monday,history_status(:,2))

    fignum=fignum+1;figure(fignum);hold on;
    title('weekly cycle');
    plot([1:7],day_average);
end

median_size=median(tin1(:,5));
%count times in which the resource is full
occupied_time=0;
occupied_time_upto_median=0;
for i=1:hcounter-1
    if (history_status(i,2)>=nodes-median_size)
        timelag=history_status(i+1,1)-history_status(i,1);
        occupied_time_upto_median=occupied_time+timelag;
        if (history_status(i,2)>=nodes)
            occupied_time=occupied_time+timelag;
        end
    end
end


show_each_line=0;
if (show_each_line)
    fignum=fignum+1;figure(fignum);hold on;

    for i=1:ndata

        %    tin1=[feittr(:,4) feittr(:,2) feittr(:,4)+feittr(:,3) feittr(:,11)];
        plot([tin1(i,2) tin1(i,2)+tin1(i,1)],[i i]);
    end
end


%the rest is for gridbot/expert
return;


history=zeros(num_tasks,3,1);%3 places: start, end, machine(0/1), 4 instances to begin with
for i=1:ndata
    wu=tin1(i,5);
    if ((~combine_resources) && tin1(i,2)<artyom_tail)%sent before tail detection
        instance=1;
    else
        instance=find(history(wu,1,:)==0,1,'first');
        if (isempty(instance))
            if (history(wu,1,1)==0)
                instance=1;
            else
                s=size(history);
                instance=s(3)+1;
                history(:,:,instance)=0;
            end
        end
    end
    history(wu,1:3,1)=[tin1(i,2) tin1(i,2)+tin1(i,3) 11];%
end

s=size(tin1_reliable);
ndata=s(1);
inst5=0;
for i=1:ndata
    wu=tin1_reliable(i,5);
    %if (tin1(i,2)<artyom_tail)
    %    instance=1;
    %else
    instance=find(history(wu,1,:)==0,1,'first');
    %end
%    if (isempty(instance) || instance<2)
 %       instance
 %       disp('instance too small for reliable');
 %   end
    
    if (isempty(instance))
        s=size(history);
        instance=s(3)+1;
        history(:,:,instance)=0;
    end
    if (instance==5)
%        disp('5 instances');
%        task_id=min_tin(5)-1+wu
        inst5=inst5+1;
    end
    %[tin1_reliable(i,2) tin1_reliable(i,2)+tin1_reliable(i,3)]
    %instance
    history(wu,1:3,instance)=[tin1_reliable(i,2) tin1_reliable(i,2)+tin1_reliable(i,3) 22];
end
%disp('5 instances for tasks');
%inst5

figure(444);
plot(history(:,1,1),history(:,2,1),'rx');hold on;
plot(history(:,1,2),history(:,2,2),'go');
plot(history(:,1,3),history(:,2,3),'b>');
plot(history(:,1,4),history(:,2,4),'k+');
s=size(history);
if (s(3)>=5)
    plot(history(:,1,5),history(:,2,5),'m*');
end
if (artyom_tail>0)
    plot([artyom_tail artyom_tail],[0 artyom_tail],'k--');hold on;
end
legend('instance 0', '1','2','3','4');


max_height=max(max(history(:,2,:)));
for i=1:num_tasks
    for instance=1:s(3)%total number of instance, max
        switch history(i,3,instance)
            case 22%reliable
                plot([history(i,1,instance) history(i,1,instance)],[0 history(i,2,instance)],'y-');
                if (combine_resources || instance>N+2)
                    plot([history(i,1,instance) history(i,1,instance)],[0 history(i,2,instance)],'b-.');
                end
            case 11%unreliable
                if (history(i,1,instance)>artyom_tail && instance > N+1)
                    plot([history(i,1,instance) history(i,1,instance)],[history(i,2,instance) max_height],'m-');
                    task_id=min_tin(5)-1+i
                end
        end
    end
end

figure(555);
[events,used,num_ur_alive]=trace(tin1,1,requested_numur);%only alive ones
plot(events(:,1),used,'b');hold on;
num_ur_alive
requested_numur=max(requested_numur,num_ur_alive)%don't let requested deprecate the real running number, at least

if (~isempty(tin1_reliable))
    [events,used,num_r]=trace(tin1_reliable,0,0);
    plot(events(:,1),used,'g');hold on;
else
    num_r=20;
end
[events,used,num_ur]=trace(tin1,0,requested_numur);
plot(events(:,1),used,'r');hold on;
num_r
num_ur
if (artyom_tail>0)
    index=find(events(:,1)>artyom_tail,1,'first');
    disp('at gridbot tail');
    num_ur=used(index)
    plot([artyom_tail artyom_tail],[0 num_ur],'k--');
end
legend('Active machines','Upper bound on all machines','upper bound Blocked by requested','GridBoT Tail detection');



end



function [events,used,numur_used]=trace(tin1,only_alive,requested_numur)

if (only_alive)
    indices=find(tin1(:,1)>0);
    tin1=tin1(indices,:);
end
starts=tin1(:,2);
starts(:,2)=1;
ends=tin1(:,2)+tin1(:,3);
ends(:,2)=-1;
events=sortrows([starts;ends]);
used=cumsum(events(:,2));
numr_used=max(used);
if (requested_numur>0)
    if (only_alive )
        if (numr_used>requested_numur)

            disp (sprintf('error in requested ur compared to used by %d',numr_used-requested_numur));
            %return;
        end
    else
        used=min(used,requested_numur);
        numr_used=min(numr_used,requested_numur);
    end
end
numur_used=numr_used;
end
