%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function [data,tin1,nodes,granularity,time_frame,tracename,partitions,start_time,images]=get_trace(trace)
%tin1 format is:
%cpu_time sent(submit)_time makespan status number_of_used_cpus


if (trace==-1)
    data='artificial_trace.dat';
    tin1=dlmread(data,'',0,0);
    nodes=3;
    granularity=1;
    tracename='artificial_trace.dat';
time_frame=0;
else
[data,description_lines,nodes,granularity,time_frame,tracename,partitions,start_time,imagesname]=init_trace(trace);
feittr=dlmread(data,'',description_lines,0);%delimiter is empty string,
%we do not wish to set the delimiter - we want it to be automatically determined
%so that multiple delimiters are considered as one.
%structure of swf file:
%2 - sent time
%3 - wait time
%4 - run time
%11 - status
%16 partition
%run submit wait
%    in1=[feittr(:,4) feittr(:,2) feittr(:,3)]
%1cpu_time 2sent(submit)_time 3makespan 4status 5number_of_used_cpus 6memory_per_cpu 7image/excutable 8partition
partition=0;
if ((size(feittr,2)>=16) && max(feittr(:,16)) > min (feittr(:,16)))%partitions only in feilteson format
    partition=1;
end
if (partition)
    tin1=[feittr(:,4) feittr(:,2) feittr(:,4)+feittr(:,3) feittr(:,11) feittr(:,5) feittr(:,10) feittr(:,14) feittr(:,16) ];
else
    tin1=[feittr(:,4) feittr(:,2) feittr(:,4)+feittr(:,3) feittr(:,11) feittr(:,5) feittr(:,10) feittr(:,14)];
end
for i=1:length(tin1)
    if (~(tin1(i,4)==0))%orig status is other than failure:
        tin1(i,4)=0;%denote an other than failed status (including a canceled one) by 0
    else
        tin1(i,4)=1;%denote a failed status by 1
    end

end
end

if(~(strcmp(imagesname,'')))
    images=load(imagesname);
    images=images(:,2);
else
    %no images file, just do a 1:1 match
    images=1:max(tin1(:,7));
end
end


function [data,description_lines,nodes,granularity,time_frame,tracename,partitions,start_time,imagesname]=init_trace(trace)
start_time=0;
time_frame=0;
imagesname='';
switch (trace)
    case 1,
        data='pwa/SHARCNET/SHARCNET-2005-1.swf';
        description_lines=29;
        %        cutoffs=[1e4 3.5e5 4.3e5 5e5 5.2e5 5.6e5  6e5 4.6e6];
        nodes=2091;
        partitions=10;
    case 2,
        tracename='LPC-EGEE-2004-1.2-cln.swf';
        data=char(strcat({'pwa/'},tracename));
        description_lines=71;
        %        cutoffs=[3e6 8e6 9e6];
        nodes=70;%or is it 140?
        partitions=2;%a small one replaced by two - can use if cleaned
        node_size=1;
        granularity=2;%?
        time_frame=[0 Inf] ;
%        time_frame=[
    case 3,
        description_lines=44;
        tracename='DAS2-fs0-2003-1.swf';
        tracename='DAS2-fs0-2003-1-short10k.swf';
        data=char(strcat({'pwa/DAS/'},tracename));212105468586
        %        data='pwa/DAS/DAS2-fs0-2003-1.swf';
        %        cutoffs=[1e4 1.2e7 1.5e7 1.6e7 1.65e7 1.85e7];%guessing
        nodes=72;%they always come in pairs
        node_size=2;
        partitions=1;
        granularity=2;%?
        time_frame=[0 Inf] ;
    case 4,
        description_lines=44;
        data='pwa/DAS/DAS2-fs1-2003-1.swf';
        %        cutoffs=[1e7 1.05e7 1.15e7 1.4e7];
    case 5,
        description_lines=44;
        data='pwa/DAS/DAS2-fs2-2003-1.swf';
        %        cutoffs=[1e7 1.05e7 1.15e7 1.4e7];%guess
    case 6,
        description_lines=44;
        data='pwa/DAS/DAS2-fs3-2003-1.swf';
        %        cutoffs=[1e7 1.05e7 1.15e7 1.4e7];%guess
    case 7,
        description_lines=44;
        data='pwa/DAS/DAS2-fs4-2003-1.swf';
        %        cutoffs=[1e7 1.05e7 1.15e7 1.4e7];%guess
    case 8,%seems like capacity was not constatnt during the run - increasing gradualy, each peak higher than previous.
        description_lines=188;
        data='pwa/LCG-2005-1.swf';
        %        cutoffs=[1e5];%guess
        dist='ev'
        nodes=26243;%by max number of simultanous running jobs...
        granularity=1;%!!!
        partitions=170;
    case 9,
        description_lines=23;%before cleaning
        data='pwa/HPC2N/HPC2N-2002-1.swf';
        %        cutoffs=[5e5 2e6 5.79e6];
    case 10,
        description_lines=23;%usable?
        data='pwa/HPC2N/HPC2N-2002-1.1-cln.swf';
        %        cutoffs=[5e5 2e6 5.79e6];
        partitions=2;%one queue though
        nodes=240;
        node_size=1;
    case 11,
        data='pwa/SDSC/SDSC-BLUE-2000-3.1-cln.swf';
        %        cutoffs=[6e4 12e4];
        description_lines=55;
    case 12,
        data='pwa/SDSC/SDSC-BLUE-2000-3.swf';
        %        cutoffs=[6e4 12e4];
        description_lines=48;
    case 13,
        data='pwa/LLNL-T3D-1996-1.swf';
        %        cutoffs=[3600];%guess
        description_lines=24;
    case 14,%a lot of tasks wait a long time because they are very big
        data='pwa/SDSC-DS-2004-1.swf';
        %data='pwa/SDSC-DS-2004-1-short.swf';%first 500 lines only
        %        cutoffs=[];%guess
        description_lines=56;
        partitions=3;
        nodes=176*8+8*32;
        granularity=8;
        time_frame=[2.15e6 3e7] ;
    case 15,
        tracename='LANL-CM5-1994-3.1-cln.swf';
        data=char(strcat({'pwa/'},tracename));%many jobs run in non-dedicated mode, so it appears like too many resources are used.
        description_lines=46;
        partitions=1;
        nodes=1024;
        granularity=32;

    case 16,%big gaps in utulization while there are many waiting jobs
        data='pwa/SDSC-Par-1995-2.1-cln.swf';
        description_lines=71;
        partitions=2;
        nodes=48+352;
        granularity=1;
    case 17,
        tracename='SDSC-Par-1995-2.1-cln.swf';
        data=char(strcat({'pwa/'},tracename));
        description_lines=71;
        partitions=2;
        nodes=48+352;
        granularity=1;
    case 18,
        tracename='grid5000_clean_trace-short10k.swf';
        %data='gwa/GRID5000/grid5000_clean_trace.swf';
        data=char(strcat({'gwa/GRID5000/'},tracename));%'gwa/GRID5000/grid5000_clean_trace-short10k.swf';
        %        data='gwa/GRID5000/grid5000_clean_trace-short100k.swf';
        description_lines=11;
        partitions=10;%guessing
        nodes=1704;%by max in trace
        granularity=1;%?
        time_frame=[0 Inf] ;
    case 19,
        tracename='ibm.swf';
        data='ibm/ibm.swf';
        description_lines=2;
        partitions=3;
        nodes=10000;%guessing - dont have info yet
        granularity=1;%?
        time_frame=[0 Inf] ;
        imagesname='ibm/IMAGES_0';
    case 20,%kvm
        %convcal -i seconds 212105468586 - start time
%2009-04-02T21:43:06.000

        tracename='ibm1.swf';
        data='ibm/ibm1.swf';
        description_lines=2;
        partitions=1;
        nodes=6522;%max in trace
        granularity=1;%?
        time_frame=[0 Inf] ;
        %dayofweek - sunday is 1
        start_time=[212105468586 21 43 4 2 5];%unixsecs hour minute month dayofmonth dayofweek]
        imagesname='ibm/IMAGES_1';
    case 21,%xen
        tracename='ibm2.swf';
        data='ibm/ibm2.swf';
        description_lines=2;
        partitions=1;
        nodes=1420;%max in trace
        granularity=1;%?
        time_frame=[0 Inf] ;
        %convcal -i seconds 212105468586 2009-04-02T21:43:06.000
        start_time=[212105468586 21 43 4 2 5];%unixsecs hour minute month dayofmonth dayofweek]
        imagesname='ibm/IMAGES_2';
        

    case 22,%plpar
        tracename='ibm3.swf';
        data='ibm/ibm3.swf';
        description_lines=2;
        partitions=1;
        nodes=845;%guessing - dont have info yet
        granularity=1;%?
        time_frame=[0 Inf] ;
        start_time=[212105468586 21 43 4 2 5];%unixsecs hour minute month dayofmonth dayofweek]
        imagesname='ibm/IMAGES_3';
    case 23,%chopped
        tracename='ibm3.swf';
        data='ibm/ibm3.swf';
        description_lines=2;
        partitions=1;
        nodes=10000;%guessing - dont have info yet
        granularity=1;%?
        time_frame=[20*30.5*24*3600 Inf] ;
    case 24,
        tracename='grid5000_clean_trace.swf';
        data=char(strcat({'gwa/GRID5000/'},tracename));%'gwa/GRID5000/grid5000_clean_trace-short10k.swf';
        description_lines=11;
        partitions=10;%guessing
        nodes=1704;%by max in trace
        granularity=1;%?
        time_frame=[0 Inf] ;

    case 25,
        %tracename='trace-like-20-52-weeks.1.swf';
%        tracename='trace-like-20-26-weeks.swf';
        tracename='trace-like-20-10-weeks-start-6.swf';
        tracename='trace.swf';
        data=char(strcat({'trace-like-20-52-weeks-start-6/'},tracename));%'gwa/GRID5000/grid5000_clean_trace-short10k.swf';
        data=char(strcat({'trace-like-20-10-weeks-start-6-new_next_cluster_time/'},tracename));%'gwa/GRID5000/grid5000_clean_trace-short10k.swf';
        %data=tracename
        description_lines=0;
        partitions=1;%guessing
        nodes=1000;%guessing....not by max in trace
        granularity=1;%?
        time_frame=[0 Inf] ;
        start_time=[0 0 0 1 1 7];%unixsecs hour minute month dayofmonth dayofweek]
    otherwise,
        disp ('choose trace');
        return;
end
end
