%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function [times,prices,on_demand,cloud_os,filename,start_point,moving_window_time,direc,current_time,start_time]=...
    get_history(region,os,type_index,cutoff_point,moving_window_number,current_time)


if ((strcmp(os,'suse')) || (strcmp(os,'linux')) || (strcmp(os,'windows')))%for artificial files - enable insertion of one filename as the first word
    on_demand=on_demand_price(os,region,type_index);%'windows','eu-west-1',8)
    cloud_os=sprintf('%s.%s',region,os);
    filename=sprintf('%s.%s',cloud_os,instance_name(type_index));
    data=load(sprintf('%s.csv',filename));
direc='';
else
    %for artificial files - enable insertion of one filename as the first word
    on_demand=1;
    direc=os;
    cloud_os=region;
    filename=region;
    data=load(filename);
    
end

%just_histories:
%1 plot histories
%2 print parameters
%3 print long_term file with prices, availability and average paid
%    year2010=212129064000;
us_east_windows_m1_small_is_rather_congested=2000*3600+final_effects_of_minimal_fee_on_eu_west;
%times=data(:,1)-went_online;%global_first_time;


%define a moving window frame. Then the results can be mixed with the long
%term results using unite_long_term_params.

if (moving_window_number>0)
    moving_window_time=3600*24*30;%at least a month
%    moving_window_number=360;%at least 360 operations
else
    moving_window_time=Inf;
end

switch (cutoff_point)
    case 1
        start_point=global_first_time;
        
    case 2
        start_point=data(1,1);
    case 3
        start_point=went_online;
    case 4

        start_point=stopped_limiting_minimal_fee;
        direc='epoch3';
    case 5%epoch 3
        [start_point,start_time]=final_effects_of_minimal_fee_on_eu_west;%Feb 2010
        end_point=year2010+207*24*3600;%July 26
        index_end=find(data(:,1)<end_point,1,'last');
        data=data(1:index_end,:);
        direc='epoch3';
    case 6
        start_point=us_east_windows_m1_small_is_rather_congested;%not really - 83 days into epoch3
    case 7
        %second epoch
        start_point=went_online;
        end_point=stopped_limiting_minimal_fee;
        index_end=find(data(:,1)<end_point,1,'last');
        data=data(1:index_end,:);
    case 8
        %fourth is 27july2010 - 8feb 2011
        start_point=year2010+208*24*3600;
        year2011=212160600000;
        end_point=year2011+39*24*3600;%February 8th
        index_end=find(data(:,1)<end_point,1,'last');
        data=data(1:index_end,:);
        direc='epoch4';
    case 9
        %fifth - [times,prices,on_demand,cloud_os,filename,start_point,moving_window_number,moving_window_time,year2010]=...
        year2011=212160600000;
        start_point=year2011+39*24*3600;%February 8th
        direc='epoch5';
    case 10
        %first - 
        start_point=global_first_time;
        end_point=went_online;
        index_end=find(data(:,1)<end_point,1,'last');
        data=data(1:index_end,:);
        
end



times=data(:,1)-start_point;%global_first_time;
prices=data(:,2);


[times,prices]=trim_window(times,prices,start_point,current_time,moving_window_number,moving_window_time);
    
bads=1;%dummy
while (~isempty(bads))
    time_diffs=times(2:end)-times(1:end-1);
    bads=find(time_diffs<0);%time goes back
    if (~isempty(bads))
        filename
        bads
        times=[times(1:bads(1)-1)  ; times(bads(1)+2:end)];
        prices=[prices(1:bads(1)-1) ;prices(bads(1)+2:end)];
    end
end
end

