%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.


function [counter2,counter1,cloud_provider,line]=...
    finalize_account(line,counter2,counter1,cloud_provider_in,price_trace,on_demand)
%only if we actually got to the spots, we need to call this function.
%if we did not get to the spots, we go to reseerved first thing, and go to
%another function, where we only pay the fixed price.

%tin1 format is:
%  1               2             3
%cpu_time sent(submit)_time makespan status number_of_used_cpus
%8 revenue
%9 damage
%place 10 insurance sum
%place 11 insurance cost
%place 12 option cost
%place 13 cprice for option
%place 14 strategy
%place 15 ex ante revenue
%place 16 ex-post revenue - computed when taken down unless it is a fixed
%price.
client=0;
T=line(1)/3600;
Tgag=ceil(T/3600);%floor(T+0.5);%round up;
revenue=line(8);
cloud_provider=0;

if (line(14)==1)%fixed alternative. TODO - count fixed_alternatives!
    client=revenue*line(1)/3600;
    [client,cloud_provider]=pay(client,cloud_provider,on_demand*Tgag);
else

    cprice_value=line(13);
    B=line(9);
    [client,counter2]=pay(client,counter2,line(11));
    [client,counter1]=pay(client,counter1,line(12));

    submit_time=line(2);
    start_time=submit_time+(line(3)-line(1));%time-(makespan-cputime)
    %true for crashes and for regular terminations, but not for
    %extrapolations
    %    if (start_time<submit_time)%this should only happen when we are trying to estmate a final account and they have not yet finished.
    %        start_time=submit_time;
    %    end

    price_trace(:,1)=price_trace(:,1)-start_time;%global_first_time;

    Tsec=line(1);%*3600;%internally convert to seconds
    first_step=find(price_trace(:,1)<=0,1,'last');
    if (isempty(first_step))
        first_step=1;
    end
    %initial_price=price(first_step-1);%We do not expect to be right at the begining of the trace here.
    last_step=find(price_trace(:,1)<=submit_time+Tsec,1,'last');%should always come out as the current end.

    price_trace=price_trace(first_step:last_step,:);
    %if the
    price_trace(1,1)=0;%start from time zero - actual start time
    prices=price_trace(:,2);
    times=price_trace(:,1);
    index=1;
    icrash=size(price_trace,1);%the end is on this cycle, always. because we always compute on the last cycle.
    %find the real crashing time
    if (line(4)==-1)
        icrash_crash=find(price_trace(:,2)>line(6),1,'first');
        if (~isempty(icrash_crash))
            icrash=icrash_crash;
            %really crash
        else
            icrash=icrash+1;%do not crash on the last index scanned
            %prevent crashing
        end
    end
    if (line(4)==0 )% 0 - NOT terminated, -1 - we don't know
        icrash=icrash+1;%do not crash on the last index scanned
    
    end

    for i=1:Tgag%hours
        next_index=find(price_trace(:,1)<=i*3600,1,'last');%for the price valid at the next hour's beginng
        if (next_index>=icrash)
            %crash during this hour, do not pay
            client=client-B+revenue*(times(icrash)-3600*(i-1))/3600;
            [client,counter2]=pay(client,counter2,-line(10));%insurance used
            break;
        else
            %no crash this hour, pay for it according to price at
            %the beginnin of the hour.
            client=client+revenue;%pay for a full hour
            if (cprice_value>0 && prices(index)>cprice_value)%options used
                [client,cloud_provider]=pay(client,cloud_provider,cprice_value);%pay chopped spot price
            client_expenses_per_usage_hour=client_expenses_per_usage_hour+counter2;
                [counter1,cloud_provider]=pay(counter1,cloud_provider,prices(index)-cprice_value);%pay chopped spot price
            else

                [client,cloud_provider]=pay(client,cloud_provider,prices(index));%pay regular spot price
            end

            index=next_index;
            if (i==Tgag)
                client=client-(Tgag-T)*revenue;%we do not earn from early shutdown;
            end
        end
    end
end
%line(17)=cloud_provider/T;
cloud_provider=cloud_provider+cloud_provider_in;
line(16)=client;%ex_post revenue
end


function [a,b]=pay(a,b,payment)
a=a-payment;
b=b+payment;
end