%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function cloud_2nd_price_loads(tin,nhosts,time_frame,tracename,do_band,user_values,pareto_index,upto_24h)
%creates new traces for various resource sizes.
%creates answers file, in the format:
%1_____________________________2_______________________________3____________________4_____________________5
%[wait_probability_by_tasks,wait_probability_by_erlang_c,wait_probability_by_time,max_nodes_is_at_least,offered_load]
%If the offered load is lower on the first couple of rows, it is because
%the system cannot take the full load of the trace, so the load is not
%real.
%all dat files are placed in a directory according to the end of the tracename.
steps=7;
answers=zeros(steps+1,5);
fignum=1;

world=2;
fill_answer(tin,steps,steps,nhosts,time_frame,answers,0,world,fignum,do_band,user_values,pareto_index,upto_24h);
return;

end

function [answers,fignum]=fill_answer(tin,i,steps,nhosts,time_frame,answers,min_resources,world,fignum,do_band,user_values,pareto_index,upto_24h)

%world=5;%debug - 3
current_nhosts=ceil(min_resources + i/steps*(nhosts-min_resources));

redo_epoch3=1;%we only need to redo for spotprice

[fignum,wait_probability_by_tasks,wait_probability_by_erlang_c,wait_probability_by_time,max_nodes_is_at_least,offered_load,congestion_fraction_by_price]=...
        cloud_2nd_price_load(tin,current_nhosts,time_frame,world,fignum,do_band,user_values,pareto_index,redo_epoch3,upto_24h)


answers(i,:)=[wait_probability_by_tasks,wait_probability_by_erlang_c,wait_probability_by_time,max_nodes_is_at_least,offered_load,congestion_fraction_by_price];
end
