%    This file is part of Spotprice - spot intance price simulation
%
%    Copyright (C) 2010-2013  Orna Agmon Ben-Yehuda
%
%    Spotprice is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    Spotprice is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with Spotprice.  If not, see <http://www.gnu.org/licenses/>.

function [fignum,wait_probability_by_tasks,wait_probability_by_erlang_c,wait_probability_by_time,max_nodes_is_at_least,offered_load,congestion_fraction_by_price]=...
    cloud_2nd_price_load(tin,nhosts,time_frame,world,fignum,do_band,user_values,pareto_index,spotprice_paper,upto_24h)
world=2;
recreate_spotprice_report=1;
if(recreate_spotprice_report)
    direc='lpc/new';nhosts=70;
else
    direc='ibm/new';
end
warning off MATLAB:colon:operandsNotRealScalar
%user_values=3;
%pareto_index=2;%1.36 by sorin solomon and levy
%do_band=0;
%take an existing workload from a trace
%consider submission times and execution times only, and number of %processors
%assume that if not enough processors are available the application waits
%for the next time slot?? or that it will take partial?
%new_trace has the same format as tin: cputime, sent time, makespan, status, and bid
%to re-do what we did for spotprice 1, need to:
%1. neutralize the call to new_minimal_price (or set the top minimal price
%to be the bottom)
%2. do not try to make money if system is not congested.
%3.limit to 1:10K
%4 use single_time_interval(p,pfactor) instead of
%single_time_interval_exp
%time frame
%we draw the same lottery each round, no matter how many cpus there are.
rand('twister',5489);%initialiation - to repeat itself
randn('state',0);%initialiation - to repeat itself
filename='price_trace_nhost_70.dat';%for prev
%single_time_interval_halflife=
travelling_light=1;
has_insurance=(world==3) || (world==5);
has_options=(world==4) || (world==5);
plotting_scale=3600*24*30.5;%month scale
if (spotprice_paper)
    redo_epoch3=1;
    %for spotprice original contradicting simulation:
    %redo_epoch3=1;%controls the waiting option vs. the fixed price option
    allow_waiting=1;
    redo_epoch3_timers=0;
    total_number_of_lines=20000;%more for spotprice
else
    redo_epoch3=0;
    allow_waiting=0;
    redo_epoch3_timers=1;
    direc_take='lpc/10K-30K/world2_allow_wait_with_band_1_linear_0.4_1_upto_24h';
    total_number_of_lines=2000;
end

%do_band=0;%constant reserve price
%for a conforming simulation - like the band Amazone EC2 has:
%do_band=1;%amazon_minimal_price=1;%random reserve price

%do_band=2; % take past prices which were between floor and ceiling and
%re-use them, or interpolate some of them.

%load "a lot of history". Later we will need to change it. we need to start
%the system with something.
if (~redo_epoch3)
    filename_long_term=sprintf('%s/%s.long_term',direc_take,filename);
    long_term_old=load(filename_long_term);
    filename_params=sprintf('%s/%s.critical_index',direc_take,filename);
    critical_index_old=load(filename_params);
    filename_ecdf_points=sprintf('%s/%s.ecdf_points',direc_take,filename);%todo - decide by critical index, not by number of points!
    ecdf_points_old=load(filename_ecdf_points);
end

maxT=24;
%prob_crash_old=crash_probabilities_for_prices(long_term_old(:,1),long_term_old(:,9),...
%    ecdf_points_old,maxT,[],[],-1);

if (upto_24h==0)
    maximal_reasonable_runtime_for_cloud=Inf;
else
    maximal_reasonable_runtime_for_cloud=3600*24*upto_24h;%24 hours, actually most of them fit under 50 hours in LPC
end
minimal_reasonable_runtime_for_cloud=60*10;%10 minutes
minimal_step_between_price_changes=0.09*3600;
tin=tin(find(tin(:,1)>minimal_reasonable_runtime_for_cloud),:);
tin=tin(find(tin(:,1)<maximal_reasonable_runtime_for_cloud),:);

if (length(tin)>10000)
    limitstart=10000;
    limitsize=min(length(tin),limitstart+total_number_of_lines);
else
    limitstart=1;
    limitsize=length(tin);
end
%following two vals were measured from the ap-southeast traces
arcoeffs=[1.0 0.7];
bottom_minimal_price=0.4;
minimal_price=bottom_minimal_price;
fixed_top_minimal_price=0.45;
top_minimal_price=fixed_top_minimal_price;
if (do_band==0)
    top_minimal_price=bottom_minimal_price;
end
standard_deviation_of_white_noise=0.39*(top_minimal_price-bottom_minimal_price);
if (limitsize>0)
    tin=tin(limitstart:limitsize,:);
end
tin(:,2)=tin(:,2)-min(tin(:,2));
tin=tin(find(tin(:,2)>=time_frame(1)),:);
submit_time=tin(:,2);
time=min(submit_time);

tin(:,1)=max(0,tin(:,1));
%run_time=tin(:,1);
required_cpus=tin(:,5);
%bids:
%create CDF
p=0.5;
pfactor=1.0;
on_demand=1.0;
price_trace=[time minimal_price];
original_trace=[time 0 0 0 minimal_price];%time and running
%[x,c]=bounded_pareto_pdf(on_demand*3,minimal_price*0.5,pareto_index);%alpha by Sorin Solomon and Moshe Levy for wealth
%sample CDF for each group of users

%should reppeat the simulation in all 4  worlds.

%use random exponent var, then apply transformation to pareto
tin(:,4)=0;%by default, we want them all to start as if they are successful.

switch (user_values)
    case 1
        user_values_string='Pareto dist.';
    case 2
        user_values_string='Normal dist.';
    case 3
        user_values_string='Linear by task length dist.';
end

max_task_length=max(tin(:,1));%normalization
max_task_length=max(24*3600,max_task_length);%for uniform normalization

for i=1:length(tin(:,5))
    switch (user_values)
        case 1
        tin(i,9)=minimal_price*0.1*exp(exprnd(1./pareto_index));%damage from a single crash
        tin(i,8)=minimal_price*exp(exprnd(1./pareto_index));%it now represents a valuation for an hour's work,
        case 2
        %use normal, this is ot fair - the bids are raised when sing ar1!!!
        tin(i,9)= chopped_normal_random(fixed_top_minimal_price,1);
        tin(i,8)=chopped_normal_random(fixed_top_minimal_price,1);
        case 3
            %proportional to task length
        tin(i,8)= minimal_price+(1-minimal_price)*tin(i,1)/max_task_length*chopped_normal_random(minimal_price,1);
        tin(i,9)=(minimal_price+(1-minimal_price)*tin(i,1)/max_task_length*chopped_normal_random(minimal_price,1))*0.5;%damage proprotional to half task length
            
    end
    %which can be upto twice the on demand.
    tin(i,7)=i;%serial number
    tin(i,6)=0;%the bid - we will fill it later, in real time.
    %place 10 insurance sum
    %place 11 insurance cost
    %place 12 option cost
    %place 13 cprice for option
    %place 14 strategy
    %place 15 ex ante revenue
    %place 16 ex-post revenue - should i compute when i take down the
    %instance or hourly for all? it is not a common hourly event. should be
    %stand alone. the history of prices is the only common thing.
end
counter2=0;%money accumulated
counter1=0;%money accumulated
cloud_provider=0;

alpha=0.7;
moving_window_number=360;
moving_window_time=3600*24*30;%??
check_congestion=1;
travelling_light=1;

offered_traffic=sum(tin(:,1).*required_cpus);
num_jobs=length(submit_time)
num_single_jobs=sum(required_cpus)
submitted=0;
finished=0;
terminated=0;
occupied=0;
host_finish_times=[];
waited=0;
immediate=0;
%todo - process finish times of failures!!!
%new_trace=[];
left_over=zeros(size(tin(1,:)));
new_trace=tin;%todo: add a link from finish times to new_trace line.
%stop using the submitted index - it does not work once I add lines in the
%middle!!!?? do i? I thin not _ add them in the end, so it is OK.
waiting_bids=[];%todo - how do i relate to waiting in the hedge mechanism - is it like strategy 0?

if(redo_epoch3_timers)
  step=ceil(60*60*single_time_interval(p,pfactor));
else
    step=ceil(60*60*single_time_interval_exp);%(p,pfactor);
end

sprintf('next random step chosen at time %d as %d',time,step)
spot_price=minimal_price;
last_price_change=0;
waiting_index=0;
rand('twister',5489);
last_window_update_time=-Inf;
last_window_update_trace_length=-Inf;
distant_old_data=1;%we always start with something distant?
%occupied=0;
fixed_alternative=[];
pouce=0;%decided not to play
free_hosts=nhosts;
prev_minimal_price=round_cent_price(bottom_minimal_price+0.1*(top_minimal_price-bottom_minimal_price));%small change to start with. do not fight a huge xhange using random.
%while (finished<num_single_jobs && (submitted<length(submit_time) && time<= submit_time(submitted+1)))
while ((~allow_waiting) && finished+terminated+size(fixed_alternative,1)+pouce<num_single_jobs || (submitted<length(submit_time)) ...
        || (allow_waiting && finished+terminated+size(fixed_alternative,1)+pouce<num_single_jobs && (submitted<length(submit_time)))) %we do not limit time, we just make sure we submitted all the
    %jobs to be submitted. since we do nto allow new submissions while busy, this should be ok.
   %i changed the && condition to || to clear the jobs.
   %change it back to && to only view ergular busy times.
    %recompute free hosts
    disp(sprintf('done with %d/%d free hosts %d/%d waiting bids %d',finished+terminated,num_single_jobs,free_hosts,nhosts,size(waiting_bids,1)))
    if ((~redo_epoch3) && travelling_light && (size(price_trace,1)-last_window_update_trace_length)>(moving_window_number/4) ...
        && (time-last_window_update_time>moving_window_time/4))
        %we should compute it outside, and we got soemthing to compute it
        %with
        %        filename='-';direc='-';%avoid writing to files
        if (0 && (size(price_trace,1)-last_window_update_trace_length)>moving_window_number*2 && ...
                (time-last_window_update_time>moving_window_time*2))
            %there is long data inside the simulation, no need to take long data
            %from another source
            distant_old_data=0;
            %todo - copy all recent data to old data.
            %we must have this for a learning algorith, I think
        end
        sprintf('re-estimating long term data: time %f trace slots %d',time/3600,length(price_trace))
        terminated
        finished
        occupied
     submitted
     length(submit_time)
         [times,prices]=times_square(price_trace(:,1),price_trace(:,2));
        [long_term,option_cost, congestion_range,prob_crash]=...
            chew_recent_data(times,prices,time,moving_window_number,moving_window_time,on_demand,'-',...
            '-', check_congestion, alpha,long_term_old,ecdf_points_old,critical_index_old,maxT,distant_old_data,world);
        last_window_update_time=time;
        last_window_update_trace_length=size(price_trace,1);
    end

    if (isempty(host_finish_times))
        new_host_finish_times=host_finish_times;
    else
        new_host_finish_times=host_finish_times(find(host_finish_times(:,1)>time),:);%filter out dones
        %finalize account for those which were gracefully done
        done_finish_times=host_finish_times(find(host_finish_times(:,1)<=time),:);
        finished=finished+size(done_finish_times,1);
        for i=1:length(done_finish_times(:,3))
            [counter2,counter1,cloud_provider,new_trace_line]=...
                finalize_account(new_trace(done_finish_times(i,3),:),counter2,counter1,cloud_provider,...
                price_trace,on_demand);
            new_trace(done_finish_times(i,3),1:length(new_trace_line))=new_trace_line;
        end
    end
%    single_submitted=    free_hosts-old_free_hosts;
%    single_sub_acc=single_sub_acc+single_submitted;
    host_finish_times=new_host_finish_times;
    occupied=size(host_finish_times,1);
    
    %sprintf('occupied 3:%d, length of finish times %d',occupied,length(host_finish_times))
    free_hosts=nhosts-occupied;
    
    original_trace=update_original_trace(original_trace,time,occupied,waiting_bids,minimal_price);
    %try to submit


%waiting_index
    while (free_hosts>0 && ((waiting_index<size(waiting_bids,1))||...
            left_over(5)>0 || ...
            (submitted<num_jobs && time>=submit_time(submitted+1))))%should this be the opposite of the external loop????

        %try the waiting bids first.
        %if we went over all waiting bids, go back to the regulars.
%this will only take one fromthe waiting bids, not give them priority over
%new arrivals! should we?
%waiting_index
        if (waiting_index<size(waiting_bids,1))%check the index
            if (left_over(5)>0)
                waiting_bids(end+1,1:length(left_over))=left_over;%save it till later, plus we need it clear
                waiting_bids(length(left_over)+1:end)=0;
                left_over(5)=0;%emptied it already
            end
            
            good_waiting_indices=find(waiting_bids(max(waiting_index,1):end,6)>=spot_price,1,'first');
            if (isempty(good_waiting_indices))
                waiting_index=size(waiting_bids,1);%mark it as not-interesting
            else%take a waiting line and start running it according to the stored line
                waiting_index=good_waiting_indices(1);
                new_trace(end+1,:)=waiting_bids(waiting_index,:);%add line
                new_trace(end,3)=new_trace(end,1)+time-new_trace(end,2);%set makespan to include delay
                [left_over,free_hosts,occupied,host_finish_times]=...
                    take_some_from_group(waiting_bids(waiting_index,:),free_hosts,occupied,host_finish_times,time,length(new_trace(:,1)));
                if (left_over(5)>0)
                    new_trace(end,5)=new_trace(end,5)-left_over(5);%just what got in
                end
                waiting_bids=[waiting_bids(1:waiting_index-1,:);waiting_bids(waiting_index+1:end,:)];%we did it already
                
                original_trace=update_original_trace(original_trace,time,occupied,waiting_bids,minimal_price);
%                plot_occupancy(new_trace,nhosts,1,1000);
            end
        end
        
        %then, try to clear left over (or new left over)

%    sprintf('occupied 5:%d, length of finish times %d, free hosts %d',occupied,length(host_finish_times),free_hosts)
        if (left_over(5)>0)%consume left over first
            if (left_over(6)>=spot_price)
            new_trace(end+1,:)=left_over;%add line
            new_trace(end,3)=new_trace(end,1)+time-new_trace(end,2);%update makespan
            [left_over,free_hosts,occupied,host_finish_times]=...
                take_some_from_group(left_over,free_hosts,occupied,host_finish_times,time,length(new_trace(:,1)));
            if (left_over(5)>0)
                 new_trace(end,5)=new_trace(end,5)-left_over(5);%just what got in
                 if (left_over(6)>spot_price)
                     %prevent anomaly - raise price now!
                     step=max(minimal_step_between_price_changes,time-last_price_change);
        sprintf('next step limited at time %f as %f, last_change at %f',time,step,last_price_change)
                 end
            end
%    sprintf('occupied 4:%d, length of finish times %d, free hosts %d',occupied,length(host_finish_times),free_hosts)
            else
                waiting_bids(end+1,1:length(left_over))=left_over;
                waiting_bids(length(left_over)+1:end)=0;
                
            end
                original_trace=update_original_trace(original_trace,time,occupied,waiting_bids,minimal_price);
        end
        
        if (left_over(5)==0 &&   (waiting_index>=size(waiting_bids,1)) &&  ...
                submitted<num_jobs && time>=submit_time(submitted+1))% time for a new submitted task, no left overs, no waiting, either.
            %still - so we tap the new tasks pool
            %a job arrived or is queued already
            submitted=submitted+1;

            if (redo_epoch3)
                new_trace(submitted,6)=new_trace(submitted,8);%bid
                %truthfully
                new_trace(submitted,14)=2;%all of them bid for the spots anyway
                new_trace(submitted,10:13)=0;%insurance and option
                %cost and parameter
            else
                %deciding what to bid by the real client
                new_trace_line=cpt_client(new_trace(submitted,:),price_trace(:,1),price_trace(:,2),long_term_old,...
                    ecdf_points_old,critical_index_old,on_demand,time,world,...
                    alpha,moving_window_number,moving_window_time,check_congestion,...
                    long_term,option_cost, congestion_range,prob_crash,travelling_light);
                new_trace(submitted,1:length(new_trace_line))=new_trace_line;
            end

            if (new_trace(submitted,6)>=spot_price)
                %approx - the left over gets the same wait time!!! this makes
                %the trace appear like things run in parallel, when they
                %actually do not!!!
                new_trace(submitted,3)=new_trace(submitted,1)+time-new_trace(submitted,2);%update makespan

                %    sprintf('occupied 7:%d, length of finish times %d, free hosts %d',occupied,length(host_finish_times),free_hosts)
                [left_over,free_hosts,occupied,host_finish_times]=...
                    take_some_from_group(new_trace(submitted,:),free_hosts,occupied,host_finish_times,time,submitted);
                %   sprintf('occupied 6:%d, length of finish times %d, free hosts %d',occupied,length(host_finish_times),free_hosts)
                
                original_trace=update_original_trace(original_trace,time,occupied,waiting_bids,minimal_price);
                if (left_over(5)>0)%there is no room
                    new_trace(submitted,5)=new_trace(submitted,5)-left_over(5);%just what got in is written on this line
                    if (left_over(6)>spot_price)%strictly, not just equal
                        %prevent anomaly - raise price as soon as possible - let the time be swallowed int he bring up!
                        step=max(minimal_step_between_price_changes,time-last_price_change);
        sprintf('next step limited at time %f as %f, last_change at %f',time,step,last_price_change)
                    end
                end
                if (time>submit_time(submitted))
                    waited=waited+required_cpus(submitted);
                    %no change to immediate
                else%time has not passed yet - right on time
                    waited=waited+left_over(5);
                    immediate=immediate+required_cpus(submitted)-left_over(5);
                end
                %we may have updated left_over now - it can be full again
            else
                %not getting into spots right now
                
                if (new_trace(submitted,14)==0 || new_trace(submitted,8)<on_demand)
                    %if chose to do nothing, or the revenue is smaller than
                    %the on demand price
                    %not using anything
                    %do I want to go to waiting???
                    %                    lost_clients(end+1,:)=new_trace(submitted,:);
                    if (new_trace(submitted,14)==0 || (~allow_waiting))
                        pouce=pouce+1;
                    else

                waiting_bids(end+1,1:length(new_trace(submitted,:)))=new_trace(submitted,:);%save it till later, plus we need it clear
                waiting_bids(length(new_trace(submitted,:))+1:end)=0;
                        %waiting_bids(end+1,:)=new_trace(submitted,:);%go to waiting - or give up???
                    end
                else
                    if (new_trace(submitted,14)==1)%fixed price
                        [counter2,counter1,cloud_provider,new_trace_line]=...
                            finalize_account(new_trace(submitted,:),counter2,counter1,cloud_provider,...
                            price_trace,on_demand);
                        new_trace(submitted,1:length(new_trace_line))=new_trace_line;
                        fixed_alternative(end+1,:)=new_trace_line;
                        
                    
                    end
                end
                new_trace(submitted,5)=0;%this task requires 0 cpus
            end
        end

    end
    
    %clear tasks with zero runtime (without updating the time!)
    %but we filter out zero timers at the entrance already!
    filtering_shorts=1;
    if (~filtering_shorts)
        new_host_finish_times=host_finish_times(find(host_finish_times(:,1)>time),:);%filter out dones
        %    single_submitted=    free_hosts-old_free_hosts;
        %    single_sub_acc=single_sub_acc+single_submitted;
        finished=finished+occupied-size(new_host_finish_times,1);
        host_finish_times=new_host_finish_times;
    end
    occupied=size(host_finish_times,1);
%    sprintf('occupied 2:%d',occupied)
    original_trace=update_original_trace(original_trace,time,occupied,waiting_bids,minimal_price);
    free_hosts=nhosts-occupied;
    
    
    %update time
    % we filled all we can fill at this time. next thing which happens is
    % either a new submit or an exit.
    next_event=-1;
    if (occupied>0)

        next_exit=host_finish_times(1);
        next_event=next_exit;
    end
    if (submitted<num_jobs && free_hosts>0)%allowed to ask
        next_submit=tin(submitted+1,2);
        if (next_submit>time)
            if (next_event>0)
                next_event=min(next_event,next_submit);
            else
                next_event=next_submit;
            end
        end
    end
    next_price_change=last_price_change+step;
    if (step<minimal_step_between_price_changes)
        disp('how did we reach this small step ??small interval')
        step
    end
    if ((next_price_change<=next_event ||(next_event==-1)) )
        next_event=next_price_change;
        if  (next_price_change-time<2)
            %the next event is the price change, but it is a close event -
            %we do not wish to change the price sooner than we should just
            %because it is the next coming thing.
            %next_event=next_price_change;
            %join the currently running and the waiting instances
            %waiting_bids(:,6)
            %host_finish_times(:,2)

            %set new minimal price
            if (do_band)
                saved_min_price=minimal_price;
                if (do_band==1)%EC2 algorithm
                    minimal_price=new_minimal_price(minimal_price,bottom_minimal_price,top_minimal_price,prev_minimal_price,arcoeffs,standard_deviation_of_white_noise);
                else
                    %new algo do_band==2
                    minimal_price=new_new_minimal_price(minimal_price,bottom_minimal_price,top_minimal_price,prev_minimal_price,price_trace(:,2));
                end
                prev_minimal_price=saved_min_price;
            end

            %set new spot price
            if (isempty(waiting_bids))
                if (isempty(host_finish_times))
                    bids_in=[];
                else
                    bids_in=host_finish_times(:,2);
                end
            else

                if (isempty(host_finish_times))
                    bids_in=waiting_bids(:,6);
                else
                    bids_in=[waiting_bids(:,6) ;host_finish_times(:,2)];
                end
            end
            if (length(bids_in)==1)%there is just one bid
                new_spot_price=minimal_price;
            else
                new_spot_price=second_price(bids_in,nhosts,minimal_price);
            end

            if (redo_epoch3_timers)
                step=ceil(60*60*single_time_interval(p,pfactor));%new
                %step
            else
                step=ceil(60*60*single_time_interval_exp);%(p,pfactor);%new
                %step
            end
            sprintf('next random step chosen at time %f as %f',time,step)
            last_price_change=time;%reset counter

            %we want a proper price history before we go to compute ex post
            %revenue and finalize the account
            %       price_trace=[price_trace;[next_price_change-1 spot_price]];
            spot_price=new_spot_price
            price_trace=[price_trace;[time spot_price]];
            if (price_trace(end,1)-price_trace(end-1,1)<minimal_step_between_price_changes)
                disp('small interval')
            end
            
            if (new_spot_price>spot_price)
                %go over all running tasks, and terminate those which got
                %kicked out due to price change (if the price jumped up)
                for i=1:length(host_finish_times(:,2))
                    if (host_finish_times(i,2)<new_spot_price)
                        terminated=terminated+1;
                        %provider termination
                        early_quit=host_finish_times(i,1)-time;
                        host_finish_times(i,1)=time;%set the finish time as the current time - a kickout
                        %cpu_time sent_time makespan status
                        line=host_finish_times(i,3);
                        
                        
                        [counter2,counter1,cloud_provider,new_trace_line]=...
                            finalize_account(new_trace(line,:),counter2,counter1,cloud_provider,...
                            price_trace,on_demand);
                        new_trace(line,1:length(new_trace_line))=new_trace_line;
                        
                        %reduce cpu time and makespan - after the revenue
                        %is computed (make sure the damage from the crash
                        %is accounted for)
                        new_trace(line,1)=new_trace(line,1)-early_quit;
                        new_trace(line,3)=new_trace(line,3)-early_quit;
                        new_trace(line,4)=1;%failure - kick out
                        occupied=occupied-1;


                    end
                end

                original_trace=update_original_trace(original_trace,time,occupied,waiting_bids,minimal_price);
            end
            %todo - condition that we only accept those above the spot price
            %todo - after a price change, go over the old tasks (waiting bids)
            %to take those which were accepted anew. maybe just push them back
            %into the tin? do it only if the price went down?
            waiting_index=0;%the last we checked
        end
    end
    %before we advance the timestep, we record statuses:
    %is there a queue?
    %is the system fully occupied?
    old_time=time;
    time=ceil(max(time,next_event));
%    if (time<=old_time)
%        old_time
%        time
 %   end
%clear after updating the time



    if (isempty(host_finish_times))
        new_host_finish_times=host_finish_times;
    else
        new_host_finish_times=host_finish_times(find(host_finish_times(:,1)>time),:);%filter out dones
        %finalize account for those which were gracefully done
        done_finish_times=host_finish_times(find(host_finish_times(:,1)<=time),:);
        finished=finished+size(done_finish_times,1);
        for i=1:length(done_finish_times(:,3))
            [counter2,counter1,cloud_provider,new_trace_line]=...
                finalize_account(new_trace(done_finish_times(i,3),:),counter2,counter1,cloud_provider,...
                price_trace,on_demand);
            new_trace(done_finish_times(i,3),1:length(new_trace_line))=new_trace_line;
        end
    end
%    single_submitted=    free_hosts-old_free_hosts;
%    single_sub_acc=single_sub_acc+single_submitted;
    host_finish_times=new_host_finish_times;
    occupied=size(host_finish_times,1);



   % new_host_finish_times=host_finish_times(find(host_finish_times(:,1)>time),:);%filter out dones
%    single_submitted=    free_hosts-old_free_hosts;
%    single_sub_acc=single_sub_acc+single_submitted;
    if (occupied>nhosts)
        occupied
        nhosts
    end
    %finished=finished+occupied-size(new_host_finish_times,1);
    %host_finish_times=new_host_finish_times;
    %occupied=size(host_finish_times,1);
%    sprintf('occupied 1:%d',occupied)
    %if (occupied>nhosts)
     %   occupied
     %   nhosts
    %end
    free_hosts=nhosts-occupied;
    
    original_trace=update_original_trace(original_trace,time,occupied,waiting_bids,minimal_price);
end

jobs_unaccounted_for=-waited-immediate+num_single_jobs;
if (~(jobs_unaccounted_for==0))
    jobs_unaccounted_for
end
total_time=time-time_frame(1);
offered_load=offered_traffic/total_time;
nhosts
wait_probability_by_tasks=waited/num_single_jobs;

if (0)
    wait_probability_by_erlang_c=erlangc(nhosts,offered_load)
else
    wait_probability_by_erlang_c=0;%temp!!!
end

[occupied_time,occupied_time_upto_median,max_nodes_is_at_least,fignum]=plot_occupancy(new_trace,nhosts,1,fignum,plotting_scale);
wait_probability_by_time=occupied_time/total_time;
mysaveas(fignum,sprintf('%s/new_trace_file_nhost_%d',direc,nhosts));%This trace is fucked up!! it goes well beyond the available resource and producestoo high an estimate on available resources!
%fignum=fignum+1;
%figure(fignum);

time_plot(original_trace(:,1)/3600,original_trace(:,2),'k-');
title('occupied in black');

fignum=fignum+1;
figure(fignum);
time_plot(price_trace(:,1)/3600,price_trace(:,2),'b');hold on;
plot(original_trace(:,1)/3600,original_trace(:,5),'k-');
plot([price_trace(end,1) price_trace(end,1)]/3600,[top_minimal_price top_minimal_price], 'k-.');
plot([price_trace(end,1) price_trace(end,1)]/3600,[bottom_minimal_price bottom_minimal_price], 'b-.');
legend('spot price','minimal price','top of band','bottom of band');
mysaveas(fignum,sprintf('%s/price_trace_nhost_%d',direc,nhosts));

[xx,yy]=times_square(price_trace(:,1)/3600,price_trace(:,2));
square_price_trace=[xx yy];
save price_trace.dat square_price_trace -ASCII -DOUBLE
system(sprintf('mv price_trace.dat %s/price_trace_nhost_%d_world%d.dat',direc,nhosts,world));
fignum=fignum+1;figure(fignum);
plot(original_trace(:,1)/3600,original_trace(:,2),'r-');hold on;
plot(original_trace(:,1)/3600,original_trace(:,3),'g-');
plot([original_trace(1,1) original_trace(end,1)]/3600,[nhosts nhosts],'k-');
legend('running','waiting','nhosts');
mysaveas(fignum,sprintf('%s/original_trace_nhost_%d',direc,nhosts));
sprintf('finished %d out of %d jobs',finished,num_single_jobs)



%finilize all accounts still running. tentatively - assume they all run
%till the end with the current price.

for i=1:length(host_finish_times(:,3))
    [counter2,counter1,cloud_provider,new_trace_line]=...
        finalize_account(new_trace(host_finish_times(i,3),:),counter2,counter1,cloud_provider,...
        price_trace,on_demand);
    new_trace(host_finish_times(i,3),1:16)=new_trace_line;
end
client_revenue=sum(new_trace(:,16));
total_runtime=sum(new_trace(:,1).*new_trace(:,5))/3600;
income_per_usage_hour=cloud_provider/total_runtime;
income_per_clock_hour_per_machine=cloud_provider/total_time;

save new_trace_file.dat new_trace -ASCII -DOUBLE
system(sprintf('mv new_trace_file.dat %s/new_trace_file_nhost_%d_world%d.dat',direc,nhosts,world));%todo - was this bug important in the paper?
index_color=1+do_band+2*(user_values-1);

colors={'k-','r*-','b','+g','k','m'};%all colors will get a - added after them.
%plot(randn(10,1),'Color',[.7 .5 0],'LineWidth',5)
[fignum,long_term,critical_index]=spot(sprintf('%s/price_trace_nhost_%d_world%d.dat',direc,nhosts,world),'-',0,colors{index_color},1,fignum,3,2,-1,-1,'.');

%[fignum,long_term,critical_index]=spot(sprintf('%s/price_trace_nhost_70.dat',direc),'-',0,'ro',1,fignum,3,2,-1,-1,direc);

congestion_fraction_by_time=wait_probability_by_time;
congestion_fraction_by_price=1-long_term(critical_index,4);

switch (do_band)
    case 0,
        band_string='Const. reserve price';
    case 1,
        band_string='AR(1) band of reserve price';
end
legend(sprintf('%s, %s',band_string,user_values_string),'location','best');
mysaveas(fignum,sprintf('%s/availability_fraction',direc));

out=[counter2 counter1 cloud_provider client_revenue total_runtime ...
    income_per_usage_hour income_per_clock_hour_per_machine congestion_fraction_by_time congestion_fraction_by_price]
save out.txt out -ASCII -DOUBLE;
outfile=sprintf('%s/price_trace_nhost_%d.revenues.world%d',direc,nhosts,world);
system(sprintf('mv out.txt %s',outfile));

save original_trace.dat original_trace -ASCII -DOUBLE
system(sprintf('mv original_trace.dat %s/original_trace_nhost_%d_world%d.dat',direc,nhosts,world));
end


function [left_over,free_hosts,occupied,host_finish_times]=...
    take_some_from_group(left_over,free_hosts,occupied,host_finish_times,time,line_number)
if (left_over(5)<0)
    left_over(5)=0;
end
if (left_over(5)>0)
    take_from_group=min(left_over(5),free_hosts);
    new_finish_times=zeros(take_from_group,2);
    new_finish_times(:,1)=time+left_over(1);
    new_finish_times(:,2)=left_over(6);%same bid for all
    new_finish_times(:,3)=line_number;
    host_finish_times=sortrows([host_finish_times ;new_finish_times]);
    left_over(5)=left_over(5)-take_from_group;
    free_hosts=free_hosts-take_from_group;
    occupied=occupied+take_from_group;
end
end


function original_trace=update_original_trace(original_trace,time,occupied,waiting_bids,minimal_price)
    if (isempty(waiting_bids))
        places34=[0 0];
    else
        places34=[size(waiting_bids(:,6)) max(waiting_bids(:,6))];
    end
    original_trace=[original_trace;[time occupied  places34(1) places34(2) minimal_price]];
end





function step_length=single_time_interval_exp%according to m1.small in us east 1 in the spotprice paper
step_length=exprnd(2.5)+0.09;
end


function [host_finish_times,occupied,finished, counter2,counter1,cloud_provider]=...
    clean_finished(host_finish_times,time,finished,...
    counter2,counter1,cloud_provider,price_trace)


    if (isempty(host_finish_times))
        new_host_finish_times=host_finish_times;
    else
        new_host_finish_times=host_finish_times(find(host_finish_times(:,1)>time),:);%filter out dones
        %finalize account for those which were gracefully done
        done_finish_times=host_finish_times(find(host_finish_times(:,1)<=time),:);
        finished=finished+size(done_finish_times,1);
        for i=1:length(done_finish_times(:,3))
            [counter2,counter1,cloud_provider,new_trace_line]=...
                finalize_account(new_trace(done_finish_times(i,3),:),counter2,counter1,cloud_provider,...
                price_trace,on_demand);
            new_trace(done_finish_times(i,3),1:length(new_trace_line))=new_trace_line;
        end
    end
%    single_submitted=    free_hosts-old_free_hosts;
%    single_sub_acc=single_sub_acc+single_submitted;
    host_finish_times=new_host_finish_times;
    occupied=size(host_finish_times,1);
end


function r=chopped_normal_random(bottom,top)
r=bottom-1;
while(r<bottom)
    r=(top+bottom)*0.5 + 0.5*(top-bottom).*randn(1);
end
end
